/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.client;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);
    public static final String TIMEOUT_TIME = "executorTimeout";

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String timeoutTime = request.header(TIMEOUT_TIME);
        if (StrUtil.isNotBlank((CharSequence)timeoutTime)) {
            int timeout = Integer.parseInt(timeoutTime);
            if (timeout <= 0) {
                return chain.proceed(request);
            }
            return chain.withReadTimeout(timeout, TimeUnit.SECONDS).withConnectTimeout(timeout, TimeUnit.SECONDS).withWriteTimeout(timeout, TimeUnit.SECONDS).proceed(chain.request());
        }
        return chain.proceed(request);
    }
}

