/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.cache;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.triple.Pair;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class CacheToken
implements Lifecycle {
    private static Cache<Pair<String, String>, String> CACHE;

    public static void add(String groupName, String namespaceId, String token) {
        CACHE.put(Pair.of(groupName, namespaceId), (Object)token);
    }

    public static String get(String groupName, String namespaceId) {
        String token = (String)CACHE.getIfPresent(Pair.of(groupName, namespaceId));
        if (StrUtil.isBlank((CharSequence)token)) {
            AccessTemplate template = (AccessTemplate)SpringContext.getBean(AccessTemplate.class);
            GroupConfig config = template.getGroupConfigAccess().getGroupConfigByGroupName(groupName, namespaceId);
            if (Objects.isNull(config)) {
                return "ER_cKqBTPzCsWA3VyuCfFoccmuIEGXjr5KT";
            }
            token = config.getToken();
            CacheToken.add(groupName, namespaceId, token);
        }
        return token;
    }

    @Override
    public void start() {
        EasyRetryLog.LOCAL.info("CacheToken start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("CacheToken stop", new Object[0]);
        CACHE.invalidateAll();
    }
}

