/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.cache;

import akka.actor.ActorRef;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheGroupScanActor
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(CacheGroupScanActor.class);
    private static Cache<String, ActorRef> CACHE;

    public static ActorRef get(String groupName, SyetemTaskTypeEnum typeEnum) {
        return (ActorRef)CACHE.getIfPresent((Object)groupName.concat(typeEnum.name()));
    }

    public static void put(String groupName, SyetemTaskTypeEnum typeEnum, ActorRef actorRef) {
        CACHE.put((Object)groupName.concat(typeEnum.name()), (Object)actorRef);
    }

    @Override
    public void start() {
        EasyRetryLog.LOCAL.info("CacheGroupScanActor start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("CacheGroupScanActor stop", new Object[0]);
        CACHE.invalidateAll();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheGroupScanActor)) {
            return false;
        }
        CacheGroupScanActor other = (CacheGroupScanActor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheGroupScanActor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CacheGroupScanActor()";
    }
}

