/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.allocate.server;

import com.aizuda.easy.retry.server.common.ServerLoadBalance;
import com.aizuda.easy.retry.server.common.allocate.common.ConsistentHashRouter;
import com.aizuda.easy.retry.server.common.allocate.common.HashFunction;
import com.aizuda.easy.retry.server.common.allocate.common.Node;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class AllocateMessageQueueConsistentHash
implements ServerLoadBalance<String, String> {
    private final int virtualNodeCnt;
    private final HashFunction customHashFunction;

    public AllocateMessageQueueConsistentHash() {
        this(10);
    }

    public AllocateMessageQueueConsistentHash(int virtualNodeCnt) {
        this(virtualNodeCnt, null);
    }

    public AllocateMessageQueueConsistentHash(int virtualNodeCnt, HashFunction customHashFunction) {
        if (virtualNodeCnt < 0) {
            throw new IllegalArgumentException("illegal virtualNodeCnt :" + virtualNodeCnt);
        }
        this.virtualNodeCnt = virtualNodeCnt;
        this.customHashFunction = customHashFunction;
    }

    @Override
    public List<String> allocate(String currentCID, List<String> groupList, List<String> serverList) {
        if (currentCID == null || currentCID.length() < 1) {
            throw new IllegalArgumentException("currentCID is empty");
        }
        if (CollectionUtils.isEmpty(groupList)) {
            throw new IllegalArgumentException("groupList is null or groupList empty");
        }
        if (CollectionUtils.isEmpty(serverList)) {
            throw new IllegalArgumentException("serverList is null or serverList empty");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!serverList.contains(currentCID)) {
            return result;
        }
        ArrayList<ClientNode> cidNodes = new ArrayList<ClientNode>();
        for (String cid : serverList) {
            cidNodes.add(new ClientNode(cid));
        }
        ConsistentHashRouter router = this.customHashFunction != null ? new ConsistentHashRouter(cidNodes, this.virtualNodeCnt, this.customHashFunction) : new ConsistentHashRouter(cidNodes, this.virtualNodeCnt);
        ArrayList<String> results = new ArrayList<String>();
        for (String groupName : groupList) {
            ClientNode clientNode = (ClientNode)router.routeNode(groupName);
            if (clientNode == null || !currentCID.equals(clientNode.getKey())) continue;
            results.add(groupName);
        }
        return results;
    }

    @Override
    public String getName() {
        return "CONSISTENT_HASH";
    }

    private static class ClientNode
    implements Node {
        private final String clientID;

        public ClientNode(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public String getKey() {
            return this.clientID;
        }
    }
}

