/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.alarm;

import com.aizuda.easy.retry.server.common.cache.CacheNotifyRateLimiter;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractFlowControl<E extends ApplicationEvent>
implements ApplicationListener<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFlowControl.class);

    protected RateLimiter getRateLimiter(String key, double rateLimiterThreshold) {
        RateLimiter rateLimiter = CacheNotifyRateLimiter.getRateLimiterByKey(key);
        if (Objects.isNull(rateLimiter) || rateLimiter.getRate() != rateLimiterThreshold) {
            CacheNotifyRateLimiter.put(key, RateLimiter.create((double)rateLimiterThreshold));
        }
        return rateLimiter;
    }
}

