/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.alarm;

import com.aizuda.easy.retry.common.core.alarm.Alarm;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EasyRetryAlarmFactory;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.alarm.AbstractFlowControl;
import com.aizuda.easy.retry.server.common.dto.AlarmInfo;
import com.aizuda.easy.retry.server.common.dto.NotifyConfigInfo;
import com.aizuda.easy.retry.server.common.triple.Triple;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;

public abstract class AbstractAlarm<E extends ApplicationEvent, A extends AlarmInfo, T>
extends AbstractFlowControl<E>
implements ApplicationListener<E>,
Runnable,
Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlarm.class);
    @Autowired
    private EasyRetryAlarmFactory easyRetryAlarmFactory;
    @Autowired
    protected AccessTemplate accessTemplate;
    private Thread thread;

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                List<A> alarmInfos = this.poll();
                if (CollectionUtils.isEmpty(alarmInfos)) continue;
                HashSet<String> namespaceIds = new HashSet<String>();
                HashSet<String> groupNames = new HashSet<String>();
                HashSet sceneNames = new HashSet();
                Map waitSendAlarmInfos = this.convertAlarmDTO(alarmInfos, namespaceIds, groupNames, sceneNames);
                Map notifyConfig = this.obtainNotifyConfig(namespaceIds, groupNames, sceneNames);
                waitSendAlarmInfos.forEach((key, list) -> {
                    List notifyConfigsList = notifyConfig.getOrDefault(key, Lists.newArrayList());
                    for (AlarmInfo alarmDTO : list) {
                        this.sendAlarm(notifyConfigsList, alarmDTO);
                    }
                });
            }
            catch (InterruptedException e) {
                EasyRetryLog.LOCAL.info("retry task fail dead letter alarm stop", new Object[0]);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("RetryTaskFailDeadLetterAlarmListener queue poll Exception", new Object[]{e});
            }
        }
    }

    protected abstract Map<Triple<String, String, T>, List<A>> convertAlarmDTO(List<A> var1, Set<String> var2, Set<String> var3, Set<T> var4);

    protected abstract Map<Triple<String, String, T>, List<NotifyConfigInfo>> obtainNotifyConfig(Set<String> var1, Set<String> var2, Set<T> var3);

    protected abstract List<A> poll() throws InterruptedException;

    protected abstract AlarmContext buildAlarmContext(A var1, NotifyConfigInfo var2);

    @Override
    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
        this.startLog();
    }

    protected abstract void startLog();

    @Override
    public void close() {
        if (Objects.nonNull(this.thread)) {
            this.thread.interrupt();
        }
    }

    protected void sendAlarm(List<NotifyConfigInfo> notifyConfigsList, A alarmDTO) {
        for (NotifyConfigInfo notifyConfig : notifyConfigsList) {
            RateLimiter rateLimiter;
            if (Objects.equals(notifyConfig.getRateLimiterStatus(), StatusEnum.YES.getStatus()) && Objects.nonNull(rateLimiter = this.getRateLimiter(this.rateLimiterKey(notifyConfig), notifyConfig.getRateLimiterThreshold().intValue())) && !RateLimiter.create((double)notifyConfig.getRateLimiterThreshold().intValue()).tryAcquire(1L, TimeUnit.SECONDS) || Objects.nonNull(((AlarmInfo)alarmDTO).getCount()) && Objects.nonNull(notifyConfig.getNotifyThreshold()) && notifyConfig.getNotifyThreshold() >= ((AlarmInfo)alarmDTO).getCount()) continue;
            AlarmContext context = this.buildAlarmContext(alarmDTO, notifyConfig);
            Alarm alarmType = this.easyRetryAlarmFactory.getAlarmType(notifyConfig.getNotifyType());
            alarmType.asyncSendMessage((Object)context);
        }
    }

    protected abstract String rateLimiterKey(NotifyConfigInfo var1);

    protected abstract int getNotifyScene();
}

