/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.akka;

import akka.actor.ActorSystem;
import com.aizuda.easy.retry.server.common.akka.SpringExtension;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AkkaConfiguration {
    private static final String CONFIG_NAME = "easyretry";
    private static final String NETTY_ACTOR_SYSTEM = "NETTY_ACTOR_SYSTEM";
    private static final String JOB_ACTOR_SYSTEM = "JOB_ACTOR_SYSTEM";
    private static final String RETRY_ACTOR_SYSTEM = "RETRY_ACTOR_SYSTEM";
    private static final String COMMON_ACTOR_SYSTEM = "COMMON_ACTOR_SYSTEM";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SpringExtension springExtension;

    @Bean(value={"commonActorSystem"})
    public ActorSystem createLogActorSystem() {
        ActorSystem system = ActorSystem.create((String)COMMON_ACTOR_SYSTEM, (Config)ConfigFactory.load((String)CONFIG_NAME));
        this.springExtension.initialize(this.applicationContext);
        return system;
    }

    @Bean(value={"nettyActorSystem"})
    public ActorSystem nettyActorSystem() {
        ActorSystem system = ActorSystem.create((String)NETTY_ACTOR_SYSTEM, (Config)ConfigFactory.load((String)CONFIG_NAME));
        this.springExtension.initialize(this.applicationContext);
        return system;
    }

    @Bean(value={"retryActorSystem"})
    public ActorSystem retryActorSystem() {
        ActorSystem system = ActorSystem.create((String)RETRY_ACTOR_SYSTEM, (Config)ConfigFactory.load((String)CONFIG_NAME));
        this.springExtension.initialize(this.applicationContext);
        return system;
    }

    @Bean(value={"jobActorSystem"})
    public ActorSystem jobActorSystem() {
        ActorSystem system = ActorSystem.create((String)JOB_ACTOR_SYSTEM, (Config)ConfigFactory.load((String)CONFIG_NAME));
        this.springExtension.initialize(this.applicationContext);
        return system;
    }
}

