/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.schedule;

import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Schedule;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.lock.LockBuilder;
import com.aizuda.easy.retry.server.common.lock.LockManager;
import com.aizuda.easy.retry.server.common.lock.LockProvider;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;

public abstract class AbstractSchedule
implements Schedule {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchedule.class);
    @Autowired
    @Qualifier(value="scheduledExecutorService")
    protected TaskScheduler taskScheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        String lockName = this.lockName();
        String lockAtMost = this.lockAtMost();
        String lockAtLeast = this.lockAtLeast();
        Assert.notBlank((CharSequence)lockAtMost, () -> new EasyRetryServerException("lockAtLeast can not be null."));
        Assert.notBlank((CharSequence)lockAtLeast, () -> new EasyRetryServerException("lockAtLeast can not be null."));
        Assert.notBlank((CharSequence)lockName, () -> new EasyRetryServerException("lockName can not be null."));
        LockProvider lockProvider = LockBuilder.newBuilder().withResident(lockName).build();
        boolean lock = false;
        try {
            lock = lockProvider.lock(Duration.parse(lockAtLeast), Duration.parse(lockAtMost));
            if (lock) {
                this.doExecute();
            }
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error(this.getClass().getName() + " execute error. lockName:[{}]", new Object[]{lockName, e});
        }
        finally {
            if (lock) {
                lockProvider.unlock();
            } else {
                LockManager.clear();
            }
        }
    }

    protected abstract void doExecute();

    protected abstract String lockName();

    protected abstract String lockAtMost();

    protected abstract String lockAtLeast();
}

