/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.register;

import cn.hutool.core.util.IdUtil;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.NodeTypeEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Register;
import com.aizuda.easy.retry.server.common.cache.CacheConsumerGroup;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.config.SystemProperties;
import com.aizuda.easy.retry.server.common.dto.ServerNodeExtAttrs;
import com.aizuda.easy.retry.server.common.handler.ServerNodeBalance;
import com.aizuda.easy.retry.server.common.register.AbstractRegister;
import com.aizuda.easy.retry.server.common.register.RegisterContext;
import com.aizuda.easy.retry.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="serverRegister")
public class ServerRegister
extends AbstractRegister {
    private static final Logger log = LoggerFactory.getLogger(ServerRegister.class);
    public static final String BEAN_NAME = "serverRegister";
    private final ScheduledExecutorService serverRegisterNode = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "server-register-node"));
    public static final int DELAY_TIME = 30;
    public static final String CURRENT_CID = IdUtil.getSnowflakeNextIdStr();
    public static final String GROUP_NAME = "DEFAULT_SERVER";
    public static final String NAMESPACE_ID = "DEFAULT_SERVER_NAMESPACE_ID";
    @Autowired
    public ServerNodeBalance serverNodeBalance;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private ServerProperties serverProperties;

    @Override
    public boolean supports(int type) {
        return this.getNodeType().equals(type);
    }

    @Override
    protected void beforeProcessor(RegisterContext context) {
        ServerNodeExtAttrs serverNodeExtAttrs = new ServerNodeExtAttrs();
        serverNodeExtAttrs.setWebPort(this.serverProperties.getPort());
        context.setGroupName(GROUP_NAME);
        context.setHostId(CURRENT_CID);
        context.setHostIp(NetUtil.getLocalIpStr());
        context.setHostPort(this.systemProperties.getNettyPort());
        context.setContextPath(Optional.ofNullable(this.serverProperties.getServlet().getContextPath()).orElse(""));
        context.setNamespaceId(NAMESPACE_ID);
        context.setExtAttrs(JsonUtil.toJsonString((Object)serverNodeExtAttrs));
    }

    @Override
    protected LocalDateTime getExpireAt() {
        return LocalDateTime.now().plusSeconds(30L);
    }

    @Override
    protected boolean doRegister(RegisterContext context, ServerNode serverNode) {
        this.refreshExpireAt(Lists.newArrayList((Object[])new ServerNode[]{serverNode}));
        return Boolean.TRUE;
    }

    @Override
    protected void afterProcessor(ServerNode serverNode) {
        try {
            ConcurrentMap<String, String> allConsumerGroupName = CacheConsumerGroup.getAllConsumerGroupName();
            if (!CollectionUtils.isEmpty(allConsumerGroupName)) {
                List serverNodes = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNodeType, (Object)NodeTypeEnum.CLIENT.getType())).in(ServerNode::getNamespaceId, new HashSet(allConsumerGroupName.values()))).in(ServerNode::getGroupName, allConsumerGroupName.keySet()));
                for (ServerNode node : serverNodes) {
                    CacheRegisterTable.addOrUpdate(node);
                }
            }
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("\u5237\u65b0\u5ba2\u6237\u7aef\u5931\u8d25", new Object[]{e});
        }
    }

    @Override
    protected Integer getNodeType() {
        return NodeTypeEnum.SERVER.getType();
    }

    @Override
    public void start() {
        EasyRetryLog.LOCAL.info("ServerRegister start", new Object[0]);
        Register register = (Register)SpringContext.getBean((String)BEAN_NAME, Register.class);
        this.serverRegisterNode.scheduleAtFixedRate(() -> register.register(new RegisterContext()), 0L, 20L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("ServerRegister close", new Object[0]);
    }
}

