/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.okhttp;

import com.aizuda.easy.retry.server.common.okhttp.OkHttp3ClientHttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.StringUtils;

class OkHttp3ClientHttpRequest
extends AbstractClientHttpRequest {
    private final OkHttpClient client;
    private final URI uri;
    private final HttpMethod method;
    @Nullable
    private StreamingHttpOutputMessage.Body body;
    @Nullable
    private FastByteArrayOutputStream bodyStream;

    public OkHttp3ClientHttpRequest(OkHttpClient client, URI uri, HttpMethod method) {
        this.client = client;
        this.uri = uri;
        this.method = method;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        Assert.state((this.body == null ? 1 : 0) != 0, (String)"Invoke either getBody or setBody; not both");
        if (this.bodyStream == null) {
            this.bodyStream = new FastByteArrayOutputStream(1024);
        }
        return this.bodyStream;
    }

    @NotNull
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        BodyRequestBody requestBody;
        if (this.body == null && this.bodyStream != null) {
            this.body = outputStream -> this.bodyStream.writeTo(outputStream);
        }
        if (this.body != null) {
            requestBody = new BodyRequestBody(headers, this.body);
        } else if (okhttp3.internal.http.HttpMethod.requiresRequestBody((String)this.getMethod().name())) {
            String header = headers.getFirst("Content-Type");
            MediaType contentType = header != null ? MediaType.parse((String)header) : null;
            requestBody = RequestBody.create((MediaType)contentType, (byte[])new byte[0]);
        } else {
            requestBody = null;
        }
        Request.Builder builder = new Request.Builder().url(this.uri.toURL());
        builder.method(this.method.name(), (RequestBody)requestBody);
        headers.forEach((headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                builder.addHeader(headerName, headerValue);
            }
        });
        Request request = builder.build();
        return new OkHttp3ClientHttpResponse(this.client.newCall(request).execute());
    }

    private static class BodyRequestBody
    extends RequestBody {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public BodyRequestBody(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        public long contentLength() {
            return this.headers.getContentLength();
        }

        @Nullable
        public MediaType contentType() {
            String contentType = this.headers.getFirst("Content-Type");
            if (StringUtils.hasText((String)contentType)) {
                return MediaType.parse((String)contentType);
            }
            return null;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.body.writeTo(sink.outputStream());
        }

        public boolean isOneShot() {
            return !this.body.repeatable();
        }
    }
}

