/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.handler;

import com.aizuda.easy.retry.common.core.enums.NodeTypeEnum;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.allocate.server.AllocateMessageQueueAveragely;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.config.SystemProperties;
import com.aizuda.easy.retry.server.common.dto.DistributeInstance;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.server.common.register.ServerRegister;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServerNodeBalance
implements Lifecycle,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(ServerNodeBalance.class);
    public static final Long INITIAL_DELAY = 10L;
    @Autowired
    protected AccessTemplate accessTemplate;
    private Thread thread = null;
    @Autowired
    protected ServerNodeMapper serverNodeMapper;
    @Autowired
    protected SystemProperties systemProperties;
    private List<Integer> bucketList;

    public void doBalance() {
        EasyRetryLog.LOCAL.info("rebalance start", new Object[0]);
        DistributeInstance.RE_BALANCE_ING.set(Boolean.TRUE);
        try {
            Set<String> podIpSet = CacheRegisterTable.getPodIdSet("DEFAULT_SERVER", "DEFAULT_SERVER_NAMESPACE_ID");
            if (CollectionUtils.isEmpty(podIpSet)) {
                EasyRetryLog.LOCAL.error("server node is empty", new Object[0]);
            }
            DistributeInstance.INSTANCE.clearConsumerBucket();
            if (CollectionUtils.isEmpty(podIpSet)) {
                return;
            }
            List<Integer> allocate = new AllocateMessageQueueAveragely().allocate(ServerRegister.CURRENT_CID, this.bucketList, (List<String>)new ArrayList<String>(podIpSet));
            DistributeInstance.INSTANCE.setConsumerBucket(allocate);
            EasyRetryLog.LOCAL.info("rebalance complete. allocate:[{}]", new Object[]{allocate});
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("rebalance error. ", new Object[]{e});
        }
        finally {
            DistributeInstance.RE_BALANCE_ING.set(Boolean.FALSE);
        }
    }

    @Override
    public void start() {
        int bucketTotal = this.systemProperties.getBucketTotal();
        this.bucketList = new ArrayList<Integer>(bucketTotal);
        for (int i = 0; i < bucketTotal; ++i) {
            this.bucketList.add(i);
        }
        EasyRetryLog.LOCAL.info("ServerNodeBalance start", new Object[0]);
        this.thread = new Thread((Runnable)this, "server-node-balance");
        this.thread.start();
    }

    private void removeNode(ConcurrentMap<String, RegisterNodeInfo> concurrentMap, Set<String> remoteHostIds, Set<String> localHostIds) {
        localHostIds.removeAll(remoteHostIds);
        for (String localHostId : localHostIds) {
            RegisterNodeInfo registerNodeInfo = (RegisterNodeInfo)concurrentMap.get(localHostId);
            CacheRegisterTable.remove(registerNodeInfo.getGroupName(), registerNodeInfo.getNamespaceId(), registerNodeInfo.getHostId());
        }
    }

    private void refreshExpireAtCache(List<ServerNode> remotePods) {
        this.refreshCache(remotePods);
    }

    private void refreshCache(List<ServerNode> remotePods) {
        for (ServerNode node : remotePods) {
            CacheRegisterTable.addOrUpdate(node);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        EasyRetryLog.LOCAL.info("ServerNodeBalance start. ", new Object[0]);
        int i = this.serverNodeMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ServerNode::getHostId, (Object)ServerRegister.CURRENT_CID));
        if (1 == i) {
            EasyRetryLog.LOCAL.info("delete node success. [{}]", new Object[]{ServerRegister.CURRENT_CID});
        } else {
            EasyRetryLog.LOCAL.info("delete node  error. [{}]", new Object[]{ServerRegister.CURRENT_CID});
        }
        EasyRetryLog.LOCAL.info("ServerNodeBalance close complete", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            TimeUnit.SECONDS.sleep(INITIAL_DELAY);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                List remotePods = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(ServerNode::getExpireAt, (Object)LocalDateTime.now())).eq(ServerNode::getNodeType, (Object)NodeTypeEnum.SERVER.getType()));
                ConcurrentMap<String, RegisterNodeInfo> concurrentMap = Optional.ofNullable(CacheRegisterTable.get("DEFAULT_SERVER", "DEFAULT_SERVER_NAMESPACE_ID")).orElse(new ConcurrentHashMap());
                Set<String> remoteHostIds = remotePods.stream().map(ServerNode::getHostId).collect(Collectors.toSet());
                Set<String> localHostIds = concurrentMap.values().stream().map(RegisterNodeInfo::getHostId).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty((Map)concurrentMap) || this.isNodeSizeNotEqual(concurrentMap.size(), remotePods.size()) || this.isNodeNotMatch(remoteHostIds, localHostIds)) {
                    this.removeNode(concurrentMap, remoteHostIds, localHostIds);
                    this.refreshCache(remotePods);
                    this.doBalance();
                    TimeUnit.SECONDS.sleep(INITIAL_DELAY);
                    continue;
                }
                this.refreshExpireAtCache(remotePods);
                concurrentMap = CacheRegisterTable.get("DEFAULT_SERVER", "DEFAULT_SERVER_NAMESPACE_ID");
                Set expireNodeSet = concurrentMap.values().stream().filter(registerNodeInfo -> registerNodeInfo.getExpireAt().isBefore(LocalDateTime.now())).collect(Collectors.toSet());
                for (RegisterNodeInfo registerNodeInfo2 : expireNodeSet) {
                    CacheRegisterTable.remove(registerNodeInfo2.getGroupName(), registerNodeInfo2.getNamespaceId(), registerNodeInfo2.getHostId());
                }
            }
            catch (InterruptedException e) {
                EasyRetryLog.LOCAL.info("check balance stop", new Object[0]);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("check balance error", new Object[]{e});
            }
            finally {
                try {
                    TimeUnit.SECONDS.sleep(this.systemProperties.getLoadBalanceCycleTime());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private boolean isNodeNotMatch(Set<String> remoteHostIds, Set<String> localHostIds) {
        boolean b;
        boolean bl = b = !remoteHostIds.containsAll(localHostIds);
        if (b) {
            EasyRetryLog.LOCAL.info("\u5224\u65ad\u8fdc\u7a0b\u8282\u70b9\u662f\u4e0d\u662f\u548c\u672c\u5730\u8282\u70b9\u4e00\u81f4. remoteHostIds:[{}] localHostIds:[{}]", new Object[]{localHostIds, remoteHostIds});
        }
        return b;
    }

    private boolean isNodeSizeNotEqual(int localNodeSize, int remoteNodeSize) {
        boolean b;
        boolean bl = b = localNodeSize != remoteNodeSize;
        if (b) {
            EasyRetryLog.LOCAL.info("\u5b58\u5728\u8fdc\u7a0b\u548c\u672c\u5730\u7f13\u5b58\u7684\u8282\u70b9\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\u5219\u89e6\u53d1rebalance. localNodeSize:[{}] remoteNodeSize:[{}]", new Object[]{localNodeSize, remoteNodeSize});
        }
        return b;
    }

    private boolean isGroupSizeNotEqual(List<GroupConfig> removeGroupConfig, Set<String> allGroup) {
        boolean b;
        boolean bl = b = allGroup.size() != removeGroupConfig.size();
        if (b) {
            EasyRetryLog.LOCAL.info("\u82e5\u5b58\u5728\u8fdc\u7a0b\u548c\u672c\u5730\u7f13\u5b58\u7684\u7ec4\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\u5219\u89e6\u53d1rebalance. localGroupSize:[{}] remoteGroupSize:[{}]", new Object[]{allGroup.size(), removeGroupConfig.size()});
        }
        return b;
    }
}

