/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.handler;

import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.ClientLoadBalance;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceManager;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ClientNodeAllocateHandler {
    private final AccessTemplate accessTemplate;

    public RegisterNodeInfo getServerNode(String allocKey, String groupName, String namespaceId, Integer routeKey) {
        Set<RegisterNodeInfo> serverNodes = CacheRegisterTable.getServerNodeSet(groupName, namespaceId);
        if (CollectionUtils.isEmpty(serverNodes)) {
            EasyRetryLog.LOCAL.warn("client node is null. groupName:[{}]", new Object[]{groupName});
            return null;
        }
        ClientLoadBalance clientLoadBalanceRandom = ClientLoadBalanceManager.getClientLoadBalance(routeKey);
        String hostId = clientLoadBalanceRandom.route(allocKey, new TreeSet<String>(serverNodes.stream().map(RegisterNodeInfo::getHostId).collect(Collectors.toSet())));
        Stream<RegisterNodeInfo> registerNodeInfoStream = serverNodes.stream().filter(s -> s.getHostId().equals(hostId));
        return registerNodeInfoStream.findFirst().orElse(null);
    }

    public ClientNodeAllocateHandler(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

