/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.client;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.URLUtil;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.model.Result;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.client.RequestMethod;
import com.aizuda.easy.retry.server.common.client.annotation.Body;
import com.aizuda.easy.retry.server.common.client.annotation.Header;
import com.aizuda.easy.retry.server.common.client.annotation.Mapping;
import com.aizuda.easy.retry.server.common.client.annotation.Param;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.handler.ClientNodeAllocateHandler;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RpcClientInvokeHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcClientInvokeHandler.class);
    private final String groupName;
    private String hostId;
    private String hostIp;
    private Integer hostPort;
    private String contextPath;
    private final boolean failRetry;
    private final int retryTimes;
    private final int retryInterval;
    private final RetryListener retryListener;
    private final boolean failover;
    private final Integer routeKey;
    private final String allocKey;
    private final Integer executorTimeout;
    private final String namespaceId;

    public RpcClientInvokeHandler(String groupName, RegisterNodeInfo registerNodeInfo, boolean failRetry, int retryTimes, int retryInterval, RetryListener retryListener, Integer routeKey, String allocKey, boolean failover, Integer executorTimeout, String namespaceId) {
        this.groupName = groupName;
        this.hostId = registerNodeInfo.getHostId();
        this.hostPort = registerNodeInfo.getHostPort();
        this.hostIp = registerNodeInfo.getHostIp();
        this.contextPath = registerNodeInfo.getContextPath();
        this.failRetry = failRetry;
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.retryListener = retryListener;
        this.failover = failover;
        this.routeKey = routeKey;
        this.allocKey = allocKey;
        this.executorTimeout = executorTimeout;
        this.namespaceId = namespaceId;
    }

    public Result invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Mapping annotation = method.getAnnotation(Mapping.class);
        Assert.notNull((Object)annotation, () -> new EasyRetryServerException("@Mapping cannot be null"));
        if (this.failover) {
            return this.doFailoverHandler(method, args, annotation);
        }
        return this.requestRemote(method, args, annotation, 1);
    }

    @NotNull
    private Result doFailoverHandler(Method method, Object[] args, Mapping annotation) throws Throwable {
        Set<RegisterNodeInfo> serverNodeSet = CacheRegisterTable.getServerNodeSet(this.groupName, this.namespaceId);
        int size = serverNodeSet.size();
        for (int count = 1; count <= size; ++count) {
            log.info("Start request client. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr()});
            Result result = this.requestRemote(method, args, annotation, count);
            if (!Objects.nonNull(result)) continue;
            return result;
        }
        throw new EasyRetryServerException("No available nodes.");
    }

    private Result requestRemote(Method method, Object[] args, Mapping mapping, int count) throws Throwable {
        try {
            ParseParasResult parasResult = this.doParseParams(method, args);
            if (RequestMethod.POST.name().equals(mapping.method().name())) {
                Assert.notNull((Object)parasResult.body, () -> new EasyRetryServerException("body cannot be null"));
            }
            RestTemplate restTemplate = (RestTemplate)SpringContext.CONTEXT.getBean(RestTemplate.class);
            Retryer<Result> retryer = this.buildResultRetryer();
            HttpHeaders requestHeaders = parasResult.requestHeaders;
            if (Objects.nonNull(this.executorTimeout)) {
                requestHeaders.set("executorTimeout", String.valueOf(this.executorTimeout));
            }
            Result result = (Result)retryer.call(() -> {
                ResponseEntity response = restTemplate.exchange(this.getUrl(mapping, parasResult.paramMap).toString(), HttpMethod.valueOf((String)mapping.method().name()), new HttpEntity(parasResult.body, (MultiValueMap)parasResult.requestHeaders), Result.class, new Object[0]);
                return Objects.requireNonNull((Result)response.getBody());
            });
            log.info("Request client success. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr()});
            return result;
        }
        catch (RestClientException ex) {
            if (ex instanceof ResourceAccessException && this.failover) {
                log.error("request client I/O error, count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
                CacheRegisterTable.remove(this.groupName, this.namespaceId, this.hostId);
                ClientNodeAllocateHandler clientNodeAllocateHandler = (ClientNodeAllocateHandler)SpringContext.CONTEXT.getBean(ClientNodeAllocateHandler.class);
                RegisterNodeInfo serverNode = clientNodeAllocateHandler.getServerNode(this.allocKey, this.groupName, this.namespaceId, this.routeKey);
                if (Objects.isNull(serverNode)) {
                    throw ex;
                }
                this.hostId = serverNode.getHostId();
                this.hostPort = serverNode.getHostPort();
                this.hostIp = serverNode.getHostIp();
                this.contextPath = serverNode.getContextPath();
            }
            log.error("request client error.count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
            throw ex;
        }
        catch (Exception ex) {
            RetryException re;
            log.error("request client unknown exception. count:[{}] clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{count, this.hostId, this.hostIp, this.hostPort, NetUtil.getLocalIpStr(), ex});
            Throwable throwable = ex;
            if (ex.getClass().isAssignableFrom(RetryException.class) && (throwable = (re = (RetryException)ex).getLastFailedAttempt().getExceptionCause()) instanceof ResourceAccessException) {
                CacheRegisterTable.remove(this.groupName, this.namespaceId, this.hostId);
            }
            throw throwable;
        }
        return null;
    }

    private Retryer<Result> buildResultRetryer() {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> this.failRetry).withStopStrategy(StopStrategies.stopAfterAttempt((int)(this.retryTimes <= 0 ? 1 : this.retryTimes))).withWaitStrategy(WaitStrategies.fixedWait((long)Math.max(this.retryInterval, 0), (TimeUnit)TimeUnit.SECONDS)).withRetryListener(this.retryListener).build();
        return retryer;
    }

    private StringBuilder getUrl(Mapping mapping, Map<String, Object> paramMap) {
        StringBuilder url = new StringBuilder();
        String format = NetUtil.getUrl((String)this.hostIp, (int)this.hostPort, (String)this.contextPath).replaceAll("/+$", "");
        url.append(format).append("/").append(mapping.path().replaceFirst("^/+", ""));
        if (!CollectionUtils.isEmpty(paramMap)) {
            String query = URLUtil.buildQuery(paramMap, null);
            url.append("?").append(query);
        }
        return url;
    }

    private ParseParasResult doParseParams(Method method, Object[] args) {
        Object body = null;
        HttpHeaders requestHeaders = new HttpHeaders();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(Body.class)) {
                body = args[i];
                continue;
            }
            if (parameter.isAnnotationPresent(Header.class)) {
                requestHeaders.add("easy-retry", JsonUtil.toJsonString((Object)args[i]));
                continue;
            }
            if (parameter.isAnnotationPresent(Param.class)) {
                paramMap.put(parameter.getAnnotation(Param.class).name(), args[i]);
                continue;
            }
            throw new EasyRetryServerException("parameter error");
        }
        ParseParasResult parseParasResult = new ParseParasResult();
        parseParasResult.setBody(body);
        parseParasResult.setParamMap(paramMap);
        parseParasResult.setRequestHeaders(requestHeaders);
        return parseParasResult;
    }

    private static class ParseParasResult {
        private Object body = null;
        private HttpHeaders requestHeaders;
        private Map<String, Object> paramMap;

        public Object getBody() {
            return this.body;
        }

        public HttpHeaders getRequestHeaders() {
            return this.requestHeaders;
        }

        public Map<String, Object> getParamMap() {
            return this.paramMap;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public void setRequestHeaders(HttpHeaders requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        public void setParamMap(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseParasResult)) {
                return false;
            }
            ParseParasResult other = (ParseParasResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            HttpHeaders this$requestHeaders = this.getRequestHeaders();
            HttpHeaders other$requestHeaders = other.getRequestHeaders();
            if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
                return false;
            }
            Map<String, Object> this$paramMap = this.getParamMap();
            Map<String, Object> other$paramMap = other.getParamMap();
            return !(this$paramMap == null ? other$paramMap != null : !((Object)this$paramMap).equals(other$paramMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ParseParasResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            HttpHeaders $requestHeaders = this.getRequestHeaders();
            result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
            Map<String, Object> $paramMap = this.getParamMap();
            result = result * 59 + ($paramMap == null ? 43 : ((Object)$paramMap).hashCode());
            return result;
        }

        public String toString() {
            return "RpcClientInvokeHandler.ParseParasResult(body=" + this.getBody() + ", requestHeaders=" + this.getRequestHeaders() + ", paramMap=" + this.getParamMap() + ")";
        }
    }
}

