/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.cache;

import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.NodeTypeEnum;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.RegisterNodeInfoConverter;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CacheRegisterTable
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(CacheRegisterTable.class);
    private static Cache<String, ConcurrentMap<String, RegisterNodeInfo>> CACHE;

    public static Set<RegisterNodeInfo> getAllPods() {
        ConcurrentMap concurrentMap = CACHE.asMap();
        if (CollectionUtils.isEmpty((Map)concurrentMap)) {
            return Sets.newHashSet();
        }
        return concurrentMap.values().stream().map(stringServerNodeConcurrentMap -> new TreeSet(stringServerNodeConcurrentMap.values())).reduce((s, y) -> {
            s.addAll(y);
            return s;
        }).orElse(new TreeSet());
    }

    public static ConcurrentMap<String, RegisterNodeInfo> get(String groupName, String namespaceId) {
        return (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
    }

    public static RegisterNodeInfo getServerNode(String groupName, String namespaceId, String hostId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
        if (Objects.isNull(concurrentMap)) {
            ServerNodeMapper serverNodeMapper = (ServerNodeMapper)SpringContext.getBeanByType(ServerNodeMapper.class);
            List serverNodes = serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNodeType, (Object)NodeTypeEnum.CLIENT.getType())).eq(ServerNode::getNamespaceId, (Object)namespaceId)).eq(ServerNode::getGroupName, (Object)groupName)).eq(ServerNode::getHostId, (Object)hostId)).orderByDesc(ServerNode::getExpireAt));
            if (CollectionUtils.isEmpty((Collection)serverNodes)) {
                return null;
            }
            CacheRegisterTable.addOrUpdate((ServerNode)serverNodes.get(0));
            concurrentMap = (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
            if (CollectionUtils.isEmpty((Map)concurrentMap)) {
                return null;
            }
        }
        return (RegisterNodeInfo)concurrentMap.get(hostId);
    }

    public static Set<RegisterNodeInfo> getServerNodeSet(String groupName, String namespaceId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
        if (CollectionUtils.isEmpty((Map)concurrentMap)) {
            ServerNodeMapper serverNodeMapper = (ServerNodeMapper)SpringContext.getBeanByType(ServerNodeMapper.class);
            List serverNodes = serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNodeType, (Object)NodeTypeEnum.CLIENT.getType())).eq(ServerNode::getNamespaceId, (Object)namespaceId)).eq(ServerNode::getGroupName, (Object)groupName));
            for (ServerNode node : serverNodes) {
                CacheRegisterTable.addOrUpdate(node);
            }
            concurrentMap = (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
            if (CollectionUtils.isEmpty((Collection)serverNodes) || CollectionUtils.isEmpty((Map)concurrentMap)) {
                return Sets.newHashSet();
            }
        }
        return new TreeSet<RegisterNodeInfo>(concurrentMap.values());
    }

    private static String getKey(String groupName, String namespaceId) {
        return groupName + "@" + namespaceId;
    }

    public static Set<String> getPodIdSet(String groupName, String namespaceId) {
        return CacheRegisterTable.getServerNodeSet(groupName, namespaceId).stream().map(RegisterNodeInfo::getHostId).collect(Collectors.toSet());
    }

    public static synchronized void refreshExpireAt(ServerNode serverNode) {
        RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode(serverNode.getGroupName(), serverNode.getNamespaceId(), serverNode.getHostId());
        if (Objects.isNull(registerNodeInfo)) {
            EasyRetryLog.LOCAL.warn("node not exists. groupName:[{}] hostId:[{}]", new Object[]{serverNode.getGroupName(), serverNode.getHostId()});
        } else {
            registerNodeInfo.setExpireAt(serverNode.getExpireAt());
        }
    }

    public static synchronized void addOrUpdate(ServerNode serverNode) {
        RegisterNodeInfo registerNodeInfo;
        ConcurrentHashMap<String, RegisterNodeInfo> concurrentMap = (ConcurrentHashMap<String, RegisterNodeInfo>)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(serverNode.getGroupName(), serverNode.getNamespaceId()));
        if (Objects.isNull(concurrentMap)) {
            EasyRetryLog.LOCAL.info("Add cache. groupName:[{}] namespaceId:[{}] hostId:[{}]", new Object[]{serverNode.getGroupName(), serverNode.getNamespaceId(), serverNode.getHostId()});
            concurrentMap = new ConcurrentHashMap<String, RegisterNodeInfo>();
            registerNodeInfo = RegisterNodeInfoConverter.INSTANCE.toRegisterNodeInfo(serverNode);
        } else {
            registerNodeInfo = concurrentMap.getOrDefault(serverNode.getHostId(), RegisterNodeInfoConverter.INSTANCE.toRegisterNodeInfo(serverNode));
            registerNodeInfo.setExpireAt(serverNode.getExpireAt());
            CacheRegisterTable.delExpireNode((ConcurrentMap<String, RegisterNodeInfo>)concurrentMap);
        }
        concurrentMap.put(serverNode.getHostId(), registerNodeInfo);
        CACHE.put((Object)CacheRegisterTable.getKey(serverNode.getGroupName(), serverNode.getNamespaceId()), concurrentMap);
    }

    private static void delExpireNode(ConcurrentMap<String, RegisterNodeInfo> concurrentMap) {
        concurrentMap.values().stream().filter(registerNodeInfo -> registerNodeInfo.getExpireAt().isBefore(LocalDateTime.now().minusSeconds(40L))).forEach(registerNodeInfo -> CacheRegisterTable.remove(registerNodeInfo.getGroupName(), registerNodeInfo.getNamespaceId(), registerNodeInfo.getHostId()));
    }

    public static void remove(String groupName, String namespaceId, String hostId) {
        ConcurrentMap concurrentMap = (ConcurrentMap)CACHE.getIfPresent((Object)CacheRegisterTable.getKey(groupName, namespaceId));
        if (Objects.isNull(concurrentMap)) {
            return;
        }
        EasyRetryLog.LOCAL.info("Remove cache. groupName:[{}] hostId:[{}]", new Object[]{groupName, hostId});
        concurrentMap.remove(hostId);
    }

    @Override
    public void start() {
        EasyRetryLog.LOCAL.info("CacheRegisterTable start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("CacheRegisterTable stop", new Object[0]);
        CACHE.invalidateAll();
    }
}

