/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.cache;

import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheConsumerGroup
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(CacheConsumerGroup.class);
    private static Cache<String, String> CACHE;

    public static ConcurrentMap<String, String> getAllConsumerGroupName() {
        return CACHE.asMap();
    }

    public static synchronized void addOrUpdate(String groupName, String namespaceId) {
        CACHE.put((Object)groupName, (Object)namespaceId);
    }

    public static void remove(String groupName) {
        EasyRetryLog.LOCAL.info("Remove consumer cache. groupName:[{}]", new Object[]{groupName});
        CACHE.invalidate((Object)groupName);
    }

    public static void clear() {
        CACHE.invalidateAll();
    }

    @Override
    public void start() {
        EasyRetryLog.LOCAL.info("CacheRegisterTable start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("CacheRegisterTable stop", new Object[0]);
        CACHE.invalidateAll();
    }
}

