/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.allocate.client;

import com.aizuda.easy.retry.server.common.ClientLoadBalance;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceConsistentHash;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceLRU;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceRandom;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceRound;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;

public class ClientLoadBalanceManager {
    public static ClientLoadBalance getClientLoadBalance(int routeType) {
        for (AllocationAlgorithmEnum algorithmEnum : AllocationAlgorithmEnum.values()) {
            if (algorithmEnum.getType() != routeType) continue;
            return algorithmEnum.getClientLoadBalance();
        }
        throw new EasyRetryServerException("routeType is not existed. routeType:[{}]", routeType);
    }

    public static enum AllocationAlgorithmEnum {
        CONSISTENT_HASH(1, new ClientLoadBalanceConsistentHash(100)),
        RANDOM(2, new ClientLoadBalanceRandom()),
        LRU(3, new ClientLoadBalanceLRU(100)),
        ROUND(4, new ClientLoadBalanceRound());

        private final int type;
        private final ClientLoadBalance clientLoadBalance;

        private AllocationAlgorithmEnum(int type, ClientLoadBalance clientLoadBalance) {
            this.type = type;
            this.clientLoadBalance = clientLoadBalance;
        }

        public int getType() {
            return this.type;
        }

        public ClientLoadBalance getClientLoadBalance() {
            return this.clientLoadBalance;
        }
    }
}

