/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.allocate.client;

import com.aizuda.easy.retry.server.common.ClientLoadBalance;
import com.aizuda.easy.retry.server.common.allocate.client.ClientLoadBalanceManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ClientLoadBalanceLRU
implements ClientLoadBalance {
    private int size;
    private ConcurrentHashMap<String, LinkedHashMap<String, String>> LRU_CACHE = new ConcurrentHashMap();

    public ClientLoadBalanceLRU(int size) {
        this.size = size;
    }

    @Override
    public String route(String allocKey, TreeSet<String> clientAllAddressSet) {
        LinkedHashMap<String, String> lruItem = this.LRU_CACHE.get(allocKey);
        if (Objects.isNull(lruItem)) {
            lruItem = new LinkedHashMap<String, String>(16, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return super.size() > ClientLoadBalanceLRU.this.size;
                }
            };
            this.LRU_CACHE.put(allocKey, lruItem);
        }
        for (String address : clientAllAddressSet) {
            lruItem.computeIfAbsent(address, key -> address);
        }
        for (String address : lruItem.keySet()) {
            if (clientAllAddressSet.contains(address)) continue;
            lruItem.remove(address);
        }
        return (String)lruItem.values().stream().findFirst().get();
    }

    @Override
    public int routeType() {
        return ClientLoadBalanceManager.AllocationAlgorithmEnum.LRU.getType();
    }
}

