/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.alarm;

import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.server.common.AlarmInfoConverter;
import com.aizuda.easy.retry.server.common.alarm.AbstractAlarm;
import com.aizuda.easy.retry.server.common.dto.JobAlarmInfo;
import com.aizuda.easy.retry.server.common.dto.NotifyConfigInfo;
import com.aizuda.easy.retry.server.common.enums.SystemModeEnum;
import com.aizuda.easy.retry.server.common.triple.ImmutableTriple;
import com.aizuda.easy.retry.server.common.triple.Triple;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobNotifyConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobNotifyConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.CollectionUtils;

public abstract class AbstractJobAlarm<E extends ApplicationEvent>
extends AbstractAlarm<E, JobAlarmInfo, Long> {
    @Autowired
    private JobNotifyConfigMapper jobNotifyConfigMapper;

    @Override
    protected Map<Triple<String, String, Long>, List<JobAlarmInfo>> convertAlarmDTO(List<JobAlarmInfo> alarmInfos, Set<String> namespaceIds, Set<String> groupNames, Set<Long> jobIds) {
        return alarmInfos.stream().collect(Collectors.groupingBy(i -> {
            String namespaceId = i.getNamespaceId();
            String groupName = i.getGroupName();
            Long jobId = i.getJobId();
            namespaceIds.add(namespaceId);
            groupNames.add(groupName);
            jobIds.add(jobId);
            return ImmutableTriple.of(namespaceId, groupName, jobId);
        }));
    }

    @Override
    protected Map<Triple<String, String, Long>, List<NotifyConfigInfo>> obtainNotifyConfig(Set<String> namespaceIds, Set<String> groupNames, Set<Long> jobIds) {
        List jobNotifyConfigs = this.jobNotifyConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobNotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus())).eq(JobNotifyConfig::getNotifyScene, (Object)this.getNotifyScene())).in(JobNotifyConfig::getNamespaceId, namespaceIds)).in(JobNotifyConfig::getGroupName, groupNames)).in(JobNotifyConfig::getJobId, jobIds));
        if (CollectionUtils.isEmpty((Collection)jobNotifyConfigs)) {
            return Maps.newHashMap();
        }
        List<NotifyConfigInfo> notifyConfigInfos = AlarmInfoConverter.INSTANCE.jobToNotifyConfigInfos(jobNotifyConfigs);
        return notifyConfigInfos.stream().collect(Collectors.groupingBy(i -> {
            String namespaceId = i.getNamespaceId();
            String groupName = i.getGroupName();
            Long jobId = i.getJobId();
            return ImmutableTriple.of(namespaceId, groupName, jobId);
        }));
    }

    @Override
    protected String rateLimiterKey(NotifyConfigInfo notifyConfig) {
        return MessageFormat.format("{}_{}", SystemModeEnum.JOB.name(), notifyConfig.getId());
    }
}

