/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.template.datasource.utils;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.template.datasource.exception.EasyRetryDatasourceException;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RequestDataHelper {
    private static final ThreadLocal<Map<String, Object>> REQUEST_DATA = new ThreadLocal();
    private static final String PARTITION = "group-partition";

    public static void setRequestData(Map<String, Object> requestData) {
        REQUEST_DATA.set(requestData);
    }

    public static void setPartition(int partition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PARTITION, partition);
        RequestDataHelper.setRequestData(map);
    }

    public static void setPartition(String groupName, String namespaceId) {
        if (StrUtil.isBlank((CharSequence)groupName) && StrUtil.isNotBlank((CharSequence)namespaceId)) {
            throw new EasyRetryDatasourceException("\u7ec4\u540d\u79f0\u6216\u8005\u547d\u540d\u7a7a\u95f4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GroupConfigMapper groupConfigMapper = (GroupConfigMapper)SpringContext.getBeanByType(GroupConfigMapper.class);
        GroupConfig groupConfig = (GroupConfig)groupConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupPartition}).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName));
        if (Objects.isNull(groupConfig)) {
            throw new EasyRetryDatasourceException("groupName:[{}]\u4e0d\u5b58\u5728", groupName);
        }
        RequestDataHelper.setPartition(groupConfig.getGroupPartition());
    }

    public static <T> T getRequestData(String param) {
        Map<String, Object> dataMap = RequestDataHelper.getRequestData();
        if (CollectionUtils.isNotEmpty(dataMap)) {
            return (T)dataMap.get(param);
        }
        return null;
    }

    public static Map<String, Object> getRequestData() {
        return REQUEST_DATA.get();
    }

    public static Integer getPartition() {
        Map<String, Object> requestData = RequestDataHelper.getRequestData();
        if (CollectionUtils.isEmpty(requestData)) {
            return null;
        }
        return (Integer)requestData.get(PARTITION);
    }

    public static void remove() {
        REQUEST_DATA.remove();
    }
}

