/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.template.datasource.config;

import com.aizuda.easy.retry.template.datasource.enums.DbTypeEnum;
import com.aizuda.easy.retry.template.datasource.utils.RequestDataHelper;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@ComponentScan(value={"com.aizuda.easy.retry.template.datasource.**"})
@MapperScan(value={"com.aizuda.easy.retry.template.datasource.persistence.mapper"}, sqlSessionTemplateRef="sqlSessionTemplate")
public class EasyRetryTemplateAutoConfiguration {
    private static final List<String> TABLES = Arrays.asList("retry_task", "retry_dead_letter");

    @Bean(value={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource, Environment environment, MybatisPlusInterceptor mybatisPlusInterceptor, MybatisPlusProperties mybatisPlusProperties) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        String dbType = environment.getProperty("easy-retry.db-type");
        DbTypeEnum dbTypeEnum = DbTypeEnum.modeOf(dbType);
        factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MessageFormat.format("classpath*:/{0}/mapper/*.xml", dbTypeEnum.getDb())));
        factoryBean.setPlugins(new Interceptor[]{mybatisPlusInterceptor});
        factoryBean.setTypeAliasesPackage(mybatisPlusProperties.getTypeAliasesPackage());
        factoryBean.setGlobalConfig(mybatisPlusProperties.getGlobalConfig());
        return factoryBean.getObject();
    }

    @Bean(value={"sqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(Environment environment) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)this.dynamicTableNameInnerInterceptor());
        String dbType = environment.getProperty("easy-retry.db-type");
        DbTypeEnum dbTypeEnum = DbTypeEnum.modeOf(dbType);
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(dbTypeEnum.getMpDbType()));
        return interceptor;
    }

    public DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor() {
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler((sql, tableName) -> {
            if (!TABLES.contains(tableName)) {
                return tableName;
            }
            Integer partition = RequestDataHelper.getPartition();
            RequestDataHelper.remove();
            return tableName + "_" + partition;
        });
        return dynamicTableNameInnerInterceptor;
    }
}

