/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.template.datasource.access.config;

import com.aizuda.easy.retry.common.core.enums.NodeTypeEnum;
import com.aizuda.easy.retry.common.core.enums.NotifySceneEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.aizuda.easy.retry.template.datasource.access.ConfigAccess;
import com.aizuda.easy.retry.template.datasource.enums.DbTypeEnum;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.NotifyConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.SceneConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public abstract class AbstractConfigAccess<T>
implements ConfigAccess<T> {
    @Autowired
    protected NotifyConfigMapper notifyConfigMapper;
    @Autowired
    protected SceneConfigMapper sceneConfigMapper;
    @Autowired
    protected GroupConfigMapper groupConfigMapper;
    @Autowired
    protected Environment environment;
    protected static final List<String> ALLOW_DB = Arrays.asList(DbTypeEnum.MYSQL.getDb(), DbTypeEnum.MARIADB.getDb(), DbTypeEnum.POSTGRES.getDb());

    protected DbTypeEnum getDbType() {
        String dbType = this.environment.getProperty("easy-retry.db-type");
        return DbTypeEnum.modeOf(dbType);
    }

    protected List<NotifyConfig> getByGroupIdAndNotifyScene(String groupName, Integer notifyScene, String namespaceId) {
        return this.notifyConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getGroupName, (Object)groupName)).eq(NotifyConfig::getNotifyScene, (Object)notifyScene));
    }

    private List<NotifyConfig> getByGroupIdAndSceneIdAndNotifyScene(String groupName, String sceneName, Integer notifyScene) {
        return this.notifyConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getGroupName, (Object)groupName)).eq(NotifyConfig::getSceneName, (Object)sceneName)).eq(NotifyConfig::getNotifyScene, (Object)notifyScene));
    }

    protected SceneConfig getByGroupNameAndSceneName(String groupName, String sceneName, String namespaceId) {
        return (SceneConfig)this.sceneConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneConfig::getNamespaceId, (Object)namespaceId)).eq(SceneConfig::getGroupName, (Object)groupName)).eq(SceneConfig::getSceneName, (Object)sceneName));
    }

    protected List<SceneConfig> getSceneConfigs(String groupName) {
        return this.sceneConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SceneConfig::getGroupName, (Object)groupName));
    }

    protected GroupConfig getByGroupName(String groupName, String namespaceId) {
        return (GroupConfig)this.groupConfigMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName));
    }

    protected List<NotifyConfig> getNotifyConfigs(String groupName, String namespaceId) {
        return this.notifyConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNamespaceId, (Object)namespaceId)).eq(NotifyConfig::getGroupName, (Object)groupName));
    }

    @Override
    public Set<String> getGroupNameList(String namespaceId) {
        List<GroupConfig> groupList = this.getAllConfigGroupList(namespaceId);
        return groupList.stream().map(GroupConfig::getGroupName).collect(Collectors.toSet());
    }

    @Override
    public GroupConfig getGroupConfigByGroupName(String groupName, String namespaceId) {
        return this.getByGroupName(groupName, namespaceId);
    }

    @Override
    public SceneConfig getSceneConfigByGroupNameAndSceneName(String groupName, String sceneName, String namespaceId) {
        return this.getByGroupNameAndSceneName(groupName, sceneName, namespaceId);
    }

    @Override
    public List<NotifyConfig> getNotifyConfigByGroupName(String groupName, Integer notifyScene, String namespaceId) {
        return this.getByGroupIdAndNotifyScene(groupName, notifyScene, namespaceId);
    }

    @Override
    public List<NotifyConfig> getNotifyConfigByGroupNameAndSceneName(String groupName, String sceneName, Integer notifyScene) {
        return this.getByGroupIdAndSceneIdAndNotifyScene(groupName, sceneName, notifyScene);
    }

    @Override
    public List<NotifyConfig> getNotifyListConfigByGroupName(String groupName, String namespaceId) {
        return this.getNotifyConfigs(groupName, namespaceId);
    }

    @Override
    public List<SceneConfig> getSceneConfigByGroupName(String groupName) {
        return this.getSceneConfigs(groupName);
    }

    @Override
    public List<GroupConfig> getAllOpenGroupConfig(String namespaceId) {
        return this.getAllConfigGroupList(namespaceId).stream().filter(i -> StatusEnum.YES.getStatus().equals(i.getGroupStatus())).collect(Collectors.toList());
    }

    @Override
    public Set<String> getBlacklist(String groupName, String namespaceId) {
        List sceneConfigs;
        GroupConfig groupConfig = this.getByGroupName(groupName, namespaceId);
        if (Objects.isNull(groupConfig)) {
            return Collections.EMPTY_SET;
        }
        LambdaQueryWrapper sceneConfigLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SceneConfig::getSceneName}).eq(SceneConfig::getGroupName, (Object)groupName);
        if (StatusEnum.YES.getStatus().equals(groupConfig.getGroupStatus())) {
            sceneConfigLambdaQueryWrapper.eq(SceneConfig::getSceneStatus, (Object)StatusEnum.NO.getStatus());
        }
        if (CollectionUtils.isEmpty((Collection)(sceneConfigs = this.sceneConfigMapper.selectList((Wrapper)sceneConfigLambdaQueryWrapper)))) {
            return Collections.EMPTY_SET;
        }
        return sceneConfigs.stream().map(SceneConfig::getSceneName).collect(Collectors.toSet());
    }

    @Override
    public List<GroupConfig> getAllConfigGroupList(String namespaceId) {
        List allSystemConfigGroupList = this.groupConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).orderByAsc(GroupConfig::getId));
        if (CollectionUtils.isEmpty((Collection)allSystemConfigGroupList)) {
            return Collections.EMPTY_LIST;
        }
        return allSystemConfigGroupList;
    }

    @Override
    public List<SceneConfig> getAllConfigSceneList() {
        List allSystemConfigSceneList = this.sceneConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().orderByAsc(SceneConfig::getId));
        if (CollectionUtils.isEmpty((Collection)allSystemConfigSceneList)) {
            return Collections.EMPTY_LIST;
        }
        return allSystemConfigSceneList;
    }

    @Override
    public Integer getConfigVersion(String groupName, String namespaceId) {
        GroupConfig groupConfig = this.getGroupConfigByGroupName(groupName, namespaceId);
        if (Objects.isNull(groupConfig)) {
            return 0;
        }
        return groupConfig.getVersion();
    }

    @Override
    public ConfigDTO getConfigInfo(String groupName, String namespaceId) {
        ConfigDTO configDTO = new ConfigDTO();
        configDTO.setSceneBlacklist(this.getBlacklist(groupName, namespaceId));
        configDTO.setVersion(this.getConfigVersion(groupName, namespaceId));
        List<NotifyConfig> notifyList = this.getNotifyListConfigByGroupName(groupName, namespaceId);
        ArrayList<ConfigDTO.Notify> notifies = new ArrayList<ConfigDTO.Notify>();
        for (NotifyConfig notifyConfig : notifyList) {
            NotifySceneEnum notifyScene = NotifySceneEnum.getNotifyScene((int)notifyConfig.getNotifyScene(), (NodeTypeEnum)NodeTypeEnum.CLIENT);
            if (Objects.isNull(notifyScene)) continue;
            ConfigDTO.Notify notify = new ConfigDTO.Notify();
            notify.setNotifyScene(notifyConfig.getNotifyScene());
            notify.setNotifyType(notifyConfig.getNotifyType());
            notify.setNotifyThreshold(notifyConfig.getNotifyThreshold());
            notify.setNotifyAttribute(notifyConfig.getNotifyAttribute());
            notifies.add(notify);
        }
        configDTO.setNotifyList(notifies);
        List<SceneConfig> sceneConfig = this.getSceneConfigByGroupName(groupName);
        ArrayList<ConfigDTO.Scene> sceneList = new ArrayList<ConfigDTO.Scene>();
        for (SceneConfig config : sceneConfig) {
            ConfigDTO.Scene scene = new ConfigDTO.Scene();
            scene.setSceneName(config.getSceneName());
            scene.setDdl(config.getDeadlineRequest().longValue());
            sceneList.add(scene);
        }
        configDTO.setSceneList(sceneList);
        return configDTO;
    }
}

