/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.template.datasource.access;

import com.aizuda.easy.retry.template.datasource.access.Access;
import com.aizuda.easy.retry.template.datasource.access.ConfigAccess;
import com.aizuda.easy.retry.template.datasource.access.TaskAccess;
import com.aizuda.easy.retry.template.datasource.enums.OperationTypeEnum;
import com.aizuda.easy.retry.template.datasource.exception.EasyRetryDatasourceException;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTask;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class AccessTemplate {
    protected Map<String, Access> REGISTER_ACCESS = new HashMap<String, Access>();

    public AccessTemplate(List<Access> accesses) {
        block0: for (Access access : accesses) {
            for (OperationTypeEnum typeEnum : OperationTypeEnum.values()) {
                if (!access.supports(typeEnum.name())) continue;
                this.REGISTER_ACCESS.put(typeEnum.name(), access);
                continue block0;
            }
        }
    }

    public TaskAccess<RetryTask> getRetryTaskAccess() {
        return (TaskAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY_TASK.name())).orElseThrow(() -> new EasyRetryDatasourceException("not supports operation type"));
    }

    public TaskAccess<RetryDeadLetter> getRetryDeadLetterAccess() {
        return (TaskAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.RETRY_DEAD_LETTER.name())).orElseThrow(() -> new EasyRetryDatasourceException("not supports operation type"));
    }

    public ConfigAccess<SceneConfig> getSceneConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.SCENE.name())).orElseThrow(() -> new EasyRetryDatasourceException("not supports operation type"));
    }

    public ConfigAccess<GroupConfig> getGroupConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.GROUP.name())).orElseThrow(() -> new EasyRetryDatasourceException("not supports operation type"));
    }

    public ConfigAccess<NotifyConfig> getNotifyConfigAccess() {
        return (ConfigAccess)Optional.ofNullable(this.REGISTER_ACCESS.get(OperationTypeEnum.NOTIFY.name())).orElseThrow(() -> new EasyRetryDatasourceException("not supports operation type"));
    }
}

