/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect.tinylog;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.AbstractLog;
import com.aizuda.easy.retry.common.log.level.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public class TinyLog2
extends AbstractLog {
    private static final long serialVersionUID = 1L;
    private static final int DEPTH = 5;
    private final int level;
    private final String name;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final MessageFormatter formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());

    public TinyLog2(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public TinyLog2(String name) {
        this.name = name;
        this.level = provider.getMinimumLevel().ordinal();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= org.tinylog.Level.TRACE.ordinal();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.tinylog.Level.TRACE, t, format, remote, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= org.tinylog.Level.DEBUG.ordinal();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.tinylog.Level.DEBUG, t, format, remote, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= org.tinylog.Level.INFO.ordinal();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.tinylog.Level.INFO, t, format, remote, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= org.tinylog.Level.WARN.ordinal();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.tinylog.Level.WARN, t, format, remote, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= org.tinylog.Level.ERROR.ordinal();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, org.tinylog.Level.ERROR, t, format, remote, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        this.logIfEnabled(fqcn, this.toTinyLevel(level), t, format, remote, arguments);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.level <= this.toTinyLevel(level).ordinal();
    }

    private void logIfEnabled(String fqcn, org.tinylog.Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (null == t) {
            t = TinyLog2.getLastArgumentIfThrowable(arguments);
        }
        provider.log(5, null, level, t, formatter, (Object)StrUtil.toString((Object)format), arguments);
    }

    private org.tinylog.Level toTinyLevel(Level level) {
        return switch (level) {
            case Level.TRACE -> org.tinylog.Level.TRACE;
            case Level.DEBUG -> org.tinylog.Level.DEBUG;
            case Level.INFO -> org.tinylog.Level.INFO;
            case Level.WARN -> org.tinylog.Level.WARN;
            case Level.ERROR -> org.tinylog.Level.ERROR;
            case Level.OFF -> org.tinylog.Level.OFF;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        };
    }

    private static Throwable getLastArgumentIfThrowable(Object ... arguments) {
        if (ArrayUtil.isNotEmpty((Object[])arguments) && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }
}

