/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.log.dialect.slf4j;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.dialect.AbstractLog;
import com.aizuda.easy.retry.common.log.level.Level;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;
    private final boolean isLocationAwareLogger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
        this.isLocationAwareLogger = logger instanceof LocationAwareLogger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(Slf4jLog.getSlf4jLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 0, t, format, arguments);
            } else if (Objects.nonNull(t)) {
                this.logger.trace(StrUtil.format((CharSequence)format, (Object[])arguments), t);
            } else {
                this.logger.trace(format, arguments);
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 10, t, format, arguments);
            } else if (Objects.nonNull(t)) {
                this.logger.debug(StrUtil.format((CharSequence)format, (Object[])arguments), t);
            } else {
                this.logger.debug(format, arguments);
            }
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 20, t, format, arguments);
            } else if (Objects.nonNull(t)) {
                this.logger.info(StrUtil.format((CharSequence)format, (Object[])arguments), t);
            } else {
                this.logger.info(format, arguments);
            }
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 30, t, format, arguments);
            } else if (Objects.nonNull(t)) {
                this.logger.warn(StrUtil.format((CharSequence)format, (Object[])arguments), t);
            } else {
                this.logger.warn(format, arguments);
            }
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String fqcn, Throwable t, String format, Boolean remote, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.setContextMap(remote);
            if (this.isLocationAwareLogger) {
                this.locationAwareLog((LocationAwareLogger)this.logger, fqcn, 40, t, format, arguments);
            } else if (Objects.nonNull(t)) {
                this.logger.error(StrUtil.format((CharSequence)format, (Object[])arguments), t);
            } else {
                this.logger.error(format, arguments);
            }
        }
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Boolean remote, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(fqcn, t, format, remote, arguments);
                break;
            }
            case DEBUG: {
                this.debug(fqcn, t, format, remote, arguments);
                break;
            }
            case INFO: {
                this.info(fqcn, t, format, remote, arguments);
                break;
            }
            case WARN: {
                this.warn(fqcn, t, format, remote, arguments);
                break;
            }
            case ERROR: {
                this.error(fqcn, t, format, remote, arguments);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
    }

    private void locationAwareLog(LocationAwareLogger logger, String fqcn, int level_int, Throwable t, String msgTemplate, Object[] arguments) {
        logger.log(null, fqcn, level_int, msgTemplate, arguments, t);
    }

    private static Logger getSlf4jLogger(Class<?> clazz) {
        return null == clazz ? LoggerFactory.getLogger((String)"") : LoggerFactory.getLogger(clazz);
    }

    private void setContextMap(Boolean remote) {
        if (remote.booleanValue()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("remote", remote.toString());
            MDC.setContextMap(map);
        }
    }
}

