/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.util;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.exception.EasyRetryCommonException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static String toJsonString(Object object) {
        return JsonMapper.toJsonString(object);
    }

    public static <T> T parseObject(String jsonString, Class<T> clazz) {
        return JsonMapper.toJavaObject(jsonString, clazz);
    }

    public static <T> List<T> parseList(String jsonString, Class<T> clazz) {
        JavaType javaType = JsonMapper.getCollectionType(ArrayList.class, clazz);
        return (List)JsonMapper.toJavaObject(jsonString, javaType);
    }

    public static <K, V> Map<K, V> parseHashMap(String jsonString) {
        return JsonMapper.toJavaObject(jsonString, HashMap.class);
    }

    public static <T> Map<String, T> parseHashMap(String jsonString, Class<T> clazz) {
        return (Map)JsonMapper.toJavaObject(jsonString, new TypeReference<HashMap<String, T>>(){});
    }

    public static <T> T parseObject(String jsonString, TypeReference<T> reference) {
        return (T)JsonMapper.toJavaObject(jsonString, reference);
    }

    public static JsonNode toJson(String jsonString) {
        return JsonMapper.toJson(jsonString);
    }

    public static JsonNode toJson(Object object) {
        return JsonMapper.toJson(object);
    }

    public static JsonNode toJson(byte[] jsonBytes) {
        return JsonMapper.toJson(jsonBytes);
    }

    public static class JsonMapper {
        private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
        private static final String YYYY_MM_DD = "yyyy-MM-dd";
        private static ObjectMapper objectMapper = JsonMapper.jacksonObjectMapper();

        public static ObjectMapper jacksonObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
            final DateTimeFormatter localDateFormatter = DateTimeFormatter.ofPattern(YYYY_MM_DD);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializer<LocalDate>(){

                public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeString(localDate.format(localDateFormatter));
                }
            });
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(){

                public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeString(localDateTime.format(dateTimeFormatter));
                }
            });
            javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializer<LocalDate>(){

                public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    String value = jsonParser.getValueAsString();
                    return StrUtil.isBlank((CharSequence)value) ? null : LocalDateTime.parse(value, DateTimeFormatter.ofPattern(JsonMapper.YYYY_MM_DD_HH_MM_SS)).toLocalDate();
                }
            });
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(){

                public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    String value = jsonParser.getValueAsString();
                    return StrUtil.isBlank((CharSequence)value) ? null : LocalDateTime.parse(value, DateTimeFormatter.ofPattern(JsonMapper.YYYY_MM_DD_HH_MM_SS));
                }
            });
            objectMapper.registerModule((Module)javaTimeModule);
            return objectMapper;
        }

        private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
            return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        }

        private static String toJsonString(Object object) {
            try {
                return objectMapper.writeValueAsString(object);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("\u5bf9\u8c61\u8f6cJson\u5931\u8d25\uff01", (Object)e);
            }
        }

        private static <T> T toJavaObject(String jsonString, Class<T> clazz) {
            try {
                return (T)objectMapper.readValue(jsonString, clazz);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25", (Object)jsonString, (Throwable)e);
            }
        }

        public static Object toJavaObject(String jsonString, TypeReference typeReference) {
            try {
                return objectMapper.readValue(jsonString, typeReference);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff01", (Object)e);
            }
        }

        private static Object toJavaObject(String jsonString, JavaType javaType) {
            try {
                return objectMapper.readValue(jsonString, javaType);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff01", (Object)e);
            }
        }

        private static JsonNode toJson(String jsonString) {
            try {
                return objectMapper.readTree(jsonString);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff01", (Object)e);
            }
        }

        private static JsonNode toJson(byte[] jsonBytes) {
            try {
                return objectMapper.readTree(jsonBytes);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff01", (Object)e);
            }
        }

        private static JsonNode toJson(Object object) {
            try {
                return objectMapper.valueToTree(object);
            }
            catch (Exception e) {
                throw new EasyRetryCommonException("Json\u8f6c\u5bf9\u8c61\u5931\u8d25\uff01", (Object)e);
            }
        }
    }
}

