/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.alarm;

import cn.hutool.extra.mail.MailAccount;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAttribute
extends MailAccount {
    private static final Logger log = LoggerFactory.getLogger(EmailAttribute.class);
    private static final String EMAIL_PATTERN = "^[A-Za-z0-9-._]+@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private String tos;

    public List<String> getTos() {
        String[] split = this.tos.split(";");
        Pattern p = Pattern.compile(EMAIL_PATTERN);
        ArrayList<String> emailList = new ArrayList<String>();
        for (String s : split) {
            Matcher m = p.matcher(s);
            if (m.matches()) {
                emailList.add(s);
                continue;
            }
            EasyRetryLog.LOCAL.warn("\u90ae\u7bb1\u5730\u5740: [{}] \u5730\u5740\u6709\u8bef", new Object[]{s});
        }
        return emailList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailAttribute)) {
            return false;
        }
        EmailAttribute other = (EmailAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$tos = this.getTos();
        List<String> other$tos = other.getTos();
        return !(this$tos == null ? other$tos != null : !((Object)this$tos).equals(other$tos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmailAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $tos = this.getTos();
        result = result * 59 + ($tos == null ? 43 : ((Object)$tos).hashCode());
        return result;
    }

    public void setTos(String tos) {
        this.tos = tos;
    }

    public String toString() {
        return "EmailAttribute(tos=" + this.getTos() + ")";
    }
}

