/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.window;

import com.aizuda.easy.retry.common.core.window.WindowWrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LeapArray<T> {
    private static final Logger log = LoggerFactory.getLogger(LeapArray.class);
    protected int windowLengthInMs;
    protected int sampleCount;
    protected int intervalInMs;
    private double intervalInSecond;
    protected final AtomicReferenceArray<WindowWrap<T>> array;
    private final ReentrantLock updateLock = new ReentrantLock();

    public LeapArray(int sampleCount, int intervalInMs) {
        this.windowLengthInMs = intervalInMs / sampleCount;
        this.intervalInMs = intervalInMs;
        this.intervalInSecond = (double)intervalInMs / 1000.0;
        this.sampleCount = sampleCount;
        this.array = new AtomicReferenceArray(sampleCount);
    }

    public WindowWrap<T> currentWindow() {
        return this.currentWindow(System.currentTimeMillis());
    }

    public abstract T newEmptyBucket(long var1);

    protected abstract WindowWrap<T> resetWindowTo(WindowWrap<T> var1, long var2);

    public int calculateTimeIdx(long timeMillis) {
        long timeId = timeMillis / (long)this.windowLengthInMs;
        return (int)(timeId % (long)this.array.length());
    }

    protected long calculateWindowStart(long timeMillis) {
        return timeMillis - timeMillis % (long)this.windowLengthInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowWrap<T> currentWindow(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(timeMillis);
        long windowStart = this.calculateWindowStart(timeMillis);
        while (true) {
            WindowWrap<T> old;
            if ((old = this.array.get(idx)) == null) {
                WindowWrap<T> window = new WindowWrap<T>(this.windowLengthInMs, windowStart, this.newEmptyBucket(timeMillis));
                if (this.array.compareAndSet(idx, null, window)) {
                    return window;
                }
                Thread.yield();
                continue;
            }
            if (windowStart == old.windowStart()) {
                return old;
            }
            if (windowStart > old.windowStart()) {
                if (this.updateLock.tryLock()) {
                    try {
                        WindowWrap<T> windowWrap = this.resetWindowTo(old, windowStart);
                        return windowWrap;
                    }
                    finally {
                        this.updateLock.unlock();
                    }
                }
                Thread.yield();
                continue;
            }
            if (windowStart < old.windowStart()) break;
        }
        return new WindowWrap<T>(this.windowLengthInMs, windowStart, this.newEmptyBucket(timeMillis));
    }

    public WindowWrap<T> getPreviousWindow(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(timeMillis - (long)this.windowLengthInMs);
        timeMillis -= (long)this.windowLengthInMs;
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        if (wrap.windowStart() + (long)this.windowLengthInMs < timeMillis) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getPreviousWindow() {
        return this.getPreviousWindow(System.currentTimeMillis());
    }

    public T getWindowValue(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(timeMillis);
        WindowWrap<T> bucket = this.array.get(idx);
        if (bucket == null || !bucket.isTimeInWindow(timeMillis)) {
            return null;
        }
        return bucket.value();
    }

    public boolean isWindowDeprecated(WindowWrap<T> windowWrap) {
        return this.isWindowDeprecated(System.currentTimeMillis(), windowWrap);
    }

    public boolean isWindowDeprecated(long time, WindowWrap<T> windowWrap) {
        return time - windowWrap.windowStart() > (long)this.intervalInMs;
    }

    public List<WindowWrap<T>> list() {
        return this.list(System.currentTimeMillis());
    }

    public List<WindowWrap<T>> list(long validTime) {
        int size = this.array.length();
        ArrayList<WindowWrap<T>> result = new ArrayList<WindowWrap<T>>(size);
        for (int i = 0; i < size; ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(validTime, windowWrap)) continue;
            result.add(windowWrap);
        }
        return result;
    }

    public List<WindowWrap<T>> listAll() {
        int size = this.array.length();
        ArrayList<WindowWrap<T>> result = new ArrayList<WindowWrap<T>>(size);
        for (int i = 0; i < size; ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null) continue;
            result.add(windowWrap);
        }
        return result;
    }

    public List<T> values() {
        return this.values(System.currentTimeMillis());
    }

    public List<T> values(long timeMillis) {
        if (timeMillis < 0L) {
            return new ArrayList();
        }
        int size = this.array.length();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(timeMillis, windowWrap)) continue;
            result.add(windowWrap.value());
        }
        return result;
    }

    WindowWrap<T> getValidHead(long timeMillis) {
        int idx = this.calculateTimeIdx(timeMillis + (long)this.windowLengthInMs);
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getValidHead() {
        return this.getValidHead(System.currentTimeMillis());
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getIntervalInMs() {
        return this.intervalInMs;
    }

    public double getIntervalInSecond() {
        return this.intervalInSecond;
    }

    public void debug(long time) {
        StringBuilder sb = new StringBuilder();
        List<WindowWrap<T>> lists = this.list(time);
        sb.append("Thread_").append(Thread.currentThread().getId()).append("_");
        for (WindowWrap<T> window : lists) {
            sb.append(window.windowStart()).append(":").append(window.value().toString());
        }
        System.out.println(sb.toString());
    }

    public long currentWaiting() {
        return 0L;
    }

    public void addWaiting(long time, int acquireCount) {
        throw new UnsupportedOperationException();
    }
}

