/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.util;

import com.aizuda.easy.retry.common.core.exception.EasyRetryCommonException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetUtil {
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String URL_IPV4 = "http://{0}:{1}/{2}";
    private static final String URL_IPV6 = "http://[{0}]:{1}/{2}";

    public static String getUrl(String host, int port, String contextPath) {
        String url = URL_IPV4;
        if (NetUtil.isValidIpV6(host)) {
            url = URL_IPV6;
        }
        return MessageFormat.format(url, host, String.valueOf(port), contextPath);
    }

    public static String getLocalIpStr() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new EasyRetryCommonException("\u672a\u83b7\u53d6HostAddress");
        }
    }

    private static boolean isValidIpV4(String host) {
        Pattern pattern = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        Matcher matcher = pattern.matcher(host);
        return matcher.matches();
    }

    private static boolean isValidIpV6(String host) {
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        Matcher matcher = pattern.matcher(host);
        return matcher.matches();
    }
}

