/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.util;

import com.aizuda.easy.retry.common.core.context.SpringContext;
import java.util.Objects;
import org.springframework.core.env.Environment;

public class EnvironmentUtils {
    public static final String DEFAULT_ENV = "default ";

    public static Boolean getLogStatus() {
        Environment environment = SpringContext.getBean(Environment.class);
        if (Objects.nonNull(environment)) {
            return (Boolean)environment.getProperty("easy.retry.log.status", Boolean.class, (Object)Boolean.TRUE);
        }
        return Boolean.TRUE;
    }

    public static String getActiveProfile() {
        Environment environment = SpringContext.getBean(Environment.class);
        if (Objects.isNull(environment)) {
            return DEFAULT_ENV;
        }
        String[] activeProfiles = environment.getActiveProfiles();
        if (activeProfiles.length == 0) {
            return DEFAULT_ENV;
        }
        StringBuilder envs = new StringBuilder();
        for (String activeProfile : activeProfiles) {
            envs.append(activeProfile).append(" ");
        }
        return envs.toString();
    }
}

