/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.taobao.api.TaobaoRequest;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DingDingUtils {
    private static final Logger log = LoggerFactory.getLogger(DingDingUtils.class);
    public static final String atLabel = "@{0}";

    public static OapiRobotSendRequest buildSendRequest(String title, String text, List<String> ats) {
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle(title);
        markdown.setText(StrUtil.sub((CharSequence)DingDingUtils.getAtText(ats, text, atLabel), (int)0, (int)4000));
        request.setMarkdown(markdown);
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles(ats);
        request.setAt(at);
        if (!CollectionUtils.isEmpty(ats)) {
            at.setIsAtAll(Boolean.valueOf(ats.stream().map(String::toLowerCase).anyMatch("all"::equals)));
        }
        return request;
    }

    public static String getAtText(List<String> ats, String text, String atLabel) {
        if (CollectionUtils.isEmpty(ats)) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        ats.stream().filter(CharSequenceUtil::isNotBlank).forEach(at -> sb.append(MessageFormat.format(atLabel, at)));
        return sb.toString();
    }

    public static boolean sendMessage(OapiRobotSendRequest request, String url) {
        try {
            if (StrUtil.isBlank((CharSequence)url)) {
                return false;
            }
            DefaultDingTalkClient client = new DefaultDingTalkClient(url);
            client.execute((TaobaoRequest)request);
            return true;
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("dingDingProcessNotify", new Object[]{e});
            return false;
        }
    }
}

