/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpringContext
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContext.class);
    public static ApplicationContext CONTEXT;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        CONTEXT = applicationContext;
    }

    public static <T> T getBeanByType(Class<T> clazz) {
        return (T)CONTEXT.getBean(clazz);
    }

    public static synchronized <T> T getBean(String name) {
        try {
            return (T)CONTEXT.getBean(name);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)name, (Object)exception.getMessage());
            return null;
        }
    }

    public static synchronized <T> T getBean(Class<T> requiredType) {
        try {
            return (T)CONTEXT.getBean(requiredType);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)requiredType.getName(), (Object)exception.getMessage());
            return null;
        }
    }

    public static synchronized <T> T getBean(String name, Class<T> requiredType) {
        try {
            return (T)CONTEXT.getBean(name, requiredType);
        }
        catch (NullPointerException | BeansException exception) {
            log.error(" BeanName:{} not exist\uff0cException => {}", (Object)name, (Object)exception.getMessage());
            return null;
        }
    }
}

