/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.alarm.strategy;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.QiYeWechatAttribute;
import com.aizuda.easy.retry.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.easy.retry.common.core.enums.AlarmTypeEnum;
import com.aizuda.easy.retry.common.core.util.DingDingUtils;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QiYeWechatAlarm
extends AbstractAlarm<AlarmContext> {
    private static final Logger log = LoggerFactory.getLogger(QiYeWechatAlarm.class);
    public static final String AT_LABEL = "<@{0}>";

    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.QI_YE_WECHAT.getValue();
    }

    @Override
    public boolean asyncSendMessage(AlarmContext context) {
        threadPoolExecutor.execute(() -> this.syncSendMessage(context));
        return true;
    }

    @Override
    public boolean syncSendMessage(AlarmContext context) {
        try {
            QiYeWechatAttribute qiYeWechatAttribute = JsonUtil.parseObject(context.getNotifyAttribute(), QiYeWechatAttribute.class);
            String webhookUrl = qiYeWechatAttribute.getWebhookUrl();
            if (StrUtil.isBlank((CharSequence)webhookUrl)) {
                log.error("\u8bf7\u5148\u914d\u7f6e\u5fae\u4fe1\u673a\u5668\u4eba webhookUrl");
                return false;
            }
            HashMap map = MapUtil.newHashMap();
            QiYeWechatMessageContent messageContent = new QiYeWechatMessageContent();
            messageContent.setContent(StrUtil.sub((CharSequence)DingDingUtils.getAtText(qiYeWechatAttribute.getAts(), context.getText(), AT_LABEL), (int)0, (int)4096));
            map.put("msgtype", "markdown");
            map.put("markdown", messageContent);
            HttpRequest post = HttpUtil.createPost((String)webhookUrl);
            HttpRequest request = post.body(JsonUtil.toJsonString(map), ContentType.JSON.toString());
            HttpResponse execute = request.execute();
            EasyRetryLog.LOCAL.debug(JsonUtil.toJsonString(execute), new Object[0]);
            if (execute.isOk()) {
                return true;
            }
            EasyRetryLog.LOCAL.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25:{}", new Object[]{execute.body()});
            return false;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> alarmContexts) {
        for (AlarmContext alarmContext : alarmContexts) {
            this.asyncSendMessage(alarmContext);
        }
        return Boolean.TRUE;
    }

    private static class QiYeWechatMessageContent {
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QiYeWechatMessageContent)) {
                return false;
            }
            QiYeWechatMessageContent other = (QiYeWechatMessageContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QiYeWechatMessageContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "QiYeWechatAlarm.QiYeWechatMessageContent(content=" + this.getContent() + ")";
        }
    }
}

