/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.common.core.alarm.strategy;

import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EmailAttribute;
import com.aizuda.easy.retry.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.easy.retry.common.core.enums.AlarmTypeEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import java.io.File;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class EmailAlarm
extends AbstractAlarm<AlarmContext> {
    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.EMAIL.getValue();
    }

    @Override
    public boolean asyncSendMessage(AlarmContext alarmContext) {
        threadPoolExecutor.execute(() -> this.syncSendMessage(alarmContext));
        return true;
    }

    @Override
    public boolean syncSendMessage(AlarmContext alarmContext) {
        String notifyAttribute = alarmContext.getNotifyAttribute();
        EmailAttribute emailAttribute = JsonUtil.parseObject(notifyAttribute, EmailAttribute.class);
        emailAttribute.setAuth(true);
        String text = alarmContext.getText();
        text = text.replaceAll("\n", "<br/>");
        MailUtil.send((MailAccount)emailAttribute, emailAttribute.getTos(), (String)alarmContext.getTitle(), (String)text, (boolean)true, (File[])new File[0]);
        return true;
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> alarmContexts) {
        for (AlarmContext alarmContext : alarmContexts) {
            this.asyncSendMessage(alarmContext);
        }
        return Boolean.TRUE;
    }
}

