/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.job.core.executor;

import com.aizuda.easy.retry.client.common.log.report.LogMeta;
import com.aizuda.easy.retry.client.common.log.support.EasyRetryLogManager;
import com.aizuda.easy.retry.client.common.proxy.RequestBuilder;
import com.aizuda.easy.retry.client.job.core.cache.ThreadPoolCache;
import com.aizuda.easy.retry.client.job.core.client.JobNettyClient;
import com.aizuda.easy.retry.client.job.core.log.JobLogMeta;
import com.aizuda.easy.retry.client.model.ExecuteResult;
import com.aizuda.easy.retry.client.model.request.DispatchJobResultRequest;
import com.aizuda.easy.retry.common.core.enums.JobTaskStatusEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskTypeEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.core.model.JobContext;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.common.log.enums.LogTypeEnum;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutorFutureCallback
implements FutureCallback<ExecuteResult> {
    private static final Logger log = LoggerFactory.getLogger(JobExecutorFutureCallback.class);
    private static final JobNettyClient CLIENT = (JobNettyClient)RequestBuilder.newBuilder().client(JobNettyClient.class).callback(nettyResult -> EasyRetryLog.LOCAL.info("Job execute result report successfully requestId:[{}]", new Object[]{nettyResult.getRequestId()})).build();
    private final JobContext jobContext;

    public JobExecutorFutureCallback(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public void onSuccess(ExecuteResult result) {
        try {
            this.initLogContext();
            EasyRetryLog.REMOTE.info("\u4efb\u52a1\u6267\u884c\u6210\u529f taskBatchId:[{}] [{}]", new Object[]{this.jobContext.getTaskBatchId(), JsonUtil.toJsonString((Object)result)});
            if (Objects.isNull(result)) {
                result = ExecuteResult.success();
            }
            int taskStatus = result.getStatus() == StatusEnum.NO.getStatus().intValue() ? JobTaskStatusEnum.FAIL.getStatus() : JobTaskStatusEnum.SUCCESS.getStatus();
            CLIENT.dispatchResult(this.buildDispatchJobResultRequest(result, taskStatus));
        }
        catch (Exception e) {
            EasyRetryLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.jobContext.getTaskId(), e});
        }
        finally {
            EasyRetryLogManager.removeLogMeta();
            this.stopThreadPool();
        }
    }

    public void onFailure(Throwable t) {
        try {
            this.initLogContext();
            EasyRetryLog.REMOTE.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25 taskBatchId:[{}]", new Object[]{this.jobContext.getTaskBatchId(), t});
            ExecuteResult failure = ExecuteResult.failure();
            if (t instanceof CancellationException) {
                failure.setMessage("\u4efb\u52a1\u88ab\u53d6\u6d88");
            } else {
                failure.setMessage(t.getMessage());
            }
            CLIENT.dispatchResult(this.buildDispatchJobResultRequest(failure, JobTaskStatusEnum.FAIL.getStatus()));
        }
        catch (Exception e) {
            EasyRetryLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.jobContext.getTaskId(), e});
        }
        finally {
            EasyRetryLogManager.removeLogMeta();
            this.stopThreadPool();
        }
    }

    private void initLogContext() {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(this.jobContext.getNamespaceId());
        logMeta.setTaskId(this.jobContext.getTaskId());
        logMeta.setGroupName(this.jobContext.getGroupName());
        logMeta.setJobId(this.jobContext.getJobId());
        logMeta.setTaskBatchId(this.jobContext.getTaskBatchId());
        EasyRetryLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
    }

    private void stopThreadPool() {
        if (this.jobContext.getTaskType().intValue() == JobTaskTypeEnum.CLUSTER.getType()) {
            ThreadPoolCache.stopThreadPool(this.jobContext.getTaskBatchId());
        }
    }

    private DispatchJobResultRequest buildDispatchJobResultRequest(ExecuteResult executeResult, int status) {
        DispatchJobResultRequest dispatchJobRequest = new DispatchJobResultRequest();
        dispatchJobRequest.setTaskBatchId(this.jobContext.getTaskBatchId());
        dispatchJobRequest.setGroupName(this.jobContext.getGroupName());
        dispatchJobRequest.setJobId(this.jobContext.getJobId());
        dispatchJobRequest.setTaskId(this.jobContext.getTaskId());
        dispatchJobRequest.setWorkflowTaskBatchId(this.jobContext.getWorkflowTaskBatchId());
        dispatchJobRequest.setWorkflowNodeId(this.jobContext.getWorkflowNodeId());
        dispatchJobRequest.setTaskBatchId(this.jobContext.getTaskBatchId());
        dispatchJobRequest.setTaskId(this.jobContext.getTaskId());
        dispatchJobRequest.setTaskType(this.jobContext.getTaskType());
        dispatchJobRequest.setExecuteResult(executeResult);
        dispatchJobRequest.setTaskStatus(Integer.valueOf(status));
        dispatchJobRequest.setRetry(this.jobContext.isRetry());
        dispatchJobRequest.setRetryScene(this.jobContext.getRetryScene());
        return dispatchJobRequest;
    }
}

