/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.job.core.client;

import com.aizuda.easy.retry.client.common.annotation.Authentication;
import com.aizuda.easy.retry.client.common.log.report.LogMeta;
import com.aizuda.easy.retry.client.common.log.support.EasyRetryLogManager;
import com.aizuda.easy.retry.client.job.core.IJobExecutor;
import com.aizuda.easy.retry.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.easy.retry.client.job.core.cache.ThreadPoolCache;
import com.aizuda.easy.retry.client.job.core.dto.JobExecutorInfo;
import com.aizuda.easy.retry.client.job.core.executor.AbstractJobExecutor;
import com.aizuda.easy.retry.client.job.core.executor.AnnotationJobExecutor;
import com.aizuda.easy.retry.client.job.core.log.JobLogMeta;
import com.aizuda.easy.retry.client.model.StopJobDTO;
import com.aizuda.easy.retry.client.model.request.DispatchJobRequest;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.model.JobContext;
import com.aizuda.easy.retry.common.core.model.Result;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.common.log.enums.LogTypeEnum;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job"})
public class JobEndPoint {
    private static final Logger log = LoggerFactory.getLogger(JobEndPoint.class);

    @PostMapping(value={"/dispatch/v1"})
    @Authentication
    public Result<Boolean> dispatchJob(@RequestBody @Validated DispatchJobRequest dispatchJob) {
        try {
            JobExecutorInfo jobExecutorInfo;
            JobContext jobContext = JobEndPoint.buildJobContext(dispatchJob);
            this.initLogContext(jobContext);
            if (Objects.nonNull(dispatchJob.getRetryCount()) && dispatchJob.getRetryCount() > 0) {
                EasyRetryLog.REMOTE.info("\u4efb\u52a1\u6267\u884c/\u8c03\u5ea6\u5931\u8d25\u6267\u884c\u91cd\u8bd5. \u91cd\u8bd5\u6b21\u6570:[{}]", new Object[]{dispatchJob.getRetryCount()});
            }
            if (Objects.isNull(jobExecutorInfo = JobExecutorInfoCache.get(jobContext.getExecutorInfo()))) {
                EasyRetryLog.REMOTE.error("\u6267\u884c\u5668\u914d\u7f6e\u6709\u8bef. executorInfo:[{}]", new Object[]{dispatchJob.getExecutorInfo()});
                Result result = new Result("\u6267\u884c\u5668\u914d\u7f6e\u6709\u8bef", (Object)Boolean.FALSE);
                return result;
            }
            Object executor = jobExecutorInfo.getExecutor();
            IJobExecutor jobExecutor = IJobExecutor.class.isAssignableFrom(executor.getClass()) ? (AbstractJobExecutor)executor : (IJobExecutor)SpringContext.getBeanByType(AnnotationJobExecutor.class);
            EasyRetryLog.REMOTE.info("\u6279\u6b21:[{}] \u4efb\u52a1\u8c03\u5ea6\u6210\u529f. ", new Object[]{dispatchJob.getTaskBatchId()});
            jobExecutor.jobExecute(jobContext);
        }
        catch (Exception e) {
            EasyRetryLog.REMOTE.error("\u5ba2\u6237\u7aef\u53d1\u751f\u975e\u9884\u671f\u5f02\u5e38. taskBatchId:[{}]", new Object[]{dispatchJob.getTaskBatchId()});
            throw e;
        }
        finally {
            EasyRetryLogManager.removeLogMeta();
        }
        return new Result((Object)Boolean.TRUE);
    }

    private void initLogContext(JobContext jobContext) {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(jobContext.getNamespaceId());
        logMeta.setTaskId(jobContext.getTaskId());
        logMeta.setGroupName(jobContext.getGroupName());
        logMeta.setJobId(jobContext.getJobId());
        logMeta.setTaskBatchId(jobContext.getTaskBatchId());
        EasyRetryLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
    }

    private static JobContext buildJobContext(DispatchJobRequest dispatchJob) {
        JobContext jobContext = new JobContext();
        jobContext.setJobId(dispatchJob.getJobId());
        jobContext.setNamespaceId(dispatchJob.getNamespaceId());
        jobContext.setTaskId(dispatchJob.getTaskId());
        jobContext.setTaskBatchId(dispatchJob.getTaskBatchId());
        jobContext.setGroupName(dispatchJob.getGroupName());
        jobContext.setExecutorInfo(dispatchJob.getExecutorInfo());
        jobContext.setParallelNum(dispatchJob.getParallelNum());
        jobContext.setTaskType(dispatchJob.getTaskType());
        jobContext.setExecutorTimeout(dispatchJob.getExecutorTimeout());
        jobContext.setArgsStr(dispatchJob.getArgsStr());
        jobContext.setWorkflowNodeId(dispatchJob.getWorkflowNodeId());
        jobContext.setWorkflowTaskBatchId(dispatchJob.getWorkflowTaskBatchId());
        jobContext.setRetry(dispatchJob.isRetry());
        jobContext.setRetryScene(dispatchJob.getRetryScene());
        return jobContext;
    }

    @PostMapping(value={"/stop/v1"})
    @Authentication
    public Result<Boolean> stopJob(@RequestBody @Validated StopJobDTO interruptJob) {
        ThreadPoolExecutor threadPool = ThreadPoolCache.getThreadPool(interruptJob.getTaskBatchId());
        if (Objects.isNull(threadPool) || threadPool.isShutdown() || threadPool.isTerminated()) {
            return new Result((Object)Boolean.TRUE);
        }
        ThreadPoolCache.stopThreadPool(interruptJob.getTaskBatchId());
        return new Result((Object)(threadPool.isShutdown() || threadPool.isTerminated() ? 1 : 0));
    }
}

