/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.job.core.register;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.job.core.Scanner;
import com.aizuda.easy.retry.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.easy.retry.client.job.core.dto.JobExecutorInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobExecutorRegistrar
implements Lifecycle {
    @Autowired
    private List<Scanner> scanners;

    public void registerRetryHandler(JobExecutorInfo jobExecutorInfo) {
        if (JobExecutorInfoCache.isExisted(jobExecutorInfo.getExecutorName())) {
            throw new EasyRetryClientException("\u4e0d\u5141\u8bb8executorName\u91cd\u590d\u7684", (Object)jobExecutorInfo.getExecutorName());
        }
        JobExecutorInfoCache.put(jobExecutorInfo);
    }

    public void registerRetryHandler(List<JobExecutorInfo> contextList) {
        for (JobExecutorInfo jobExecutorInfo : contextList) {
            this.registerRetryHandler(jobExecutorInfo);
        }
    }

    public void start() {
        for (Scanner scanner : this.scanners) {
            this.registerRetryHandler(scanner.doScan());
        }
    }

    public void close() {
    }
}

