/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.serializer;

import com.aizuda.easy.retry.client.core.RetryArgSerializer;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer
implements RetryArgSerializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);

    @Override
    public String serialize(Object serializeInfo) {
        return JsonUtil.toJsonString((Object)serializeInfo);
    }

    @Override
    public Object deSerialize(String infoStr, Class tClass, Method method) throws JsonProcessingException {
        Type[] paramTypes = method.getGenericParameterTypes();
        Object[] params = new Object[paramTypes.length];
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = JsonUtil.toJson((String)infoStr);
        if (Objects.isNull(jsonNode)) {
            EasyRetryLog.LOCAL.warn("jsonNode is null. infoStr:[{}]", new Object[]{infoStr});
            return params;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            JsonNode node = jsonNode.get(i);
            if (!Objects.nonNull(node)) continue;
            params[i] = mapper.readValue(node.toString(), mapper.constructType(paramTypes[i]));
        }
        return params;
    }
}

