/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import com.aizuda.easy.retry.client.common.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.common.client.NettyClient;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.common.proxy.RequestBuilder;
import com.aizuda.easy.retry.client.core.RetryExecutorParameter;
import com.aizuda.easy.retry.client.core.executor.GuavaRetryExecutor;
import com.aizuda.easy.retry.common.core.alarm.Alarm;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EasyRetryAlarmFactory;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.NotifySceneEnum;
import com.aizuda.easy.retry.common.core.util.EnvironmentUtils;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.common.core.window.Listener;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportListener
implements Listener<RetryTaskDTO> {
    private static final Logger log = LoggerFactory.getLogger(ReportListener.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static String reportErrorTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u5f02\u6b65\u6279\u91cf\u4e0a\u62a5\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    private static final NettyClient CLIENT = (NettyClient)RequestBuilder.newBuilder().client(NettyClient.class).callback(nettyResult -> EasyRetryLog.LOCAL.info("Data report successfully requestId:[{}]", new Object[]{nettyResult.getRequestId()})).build();

    public void handler(List<RetryTaskDTO> list) {
        GuavaRetryExecutor retryExecutor = new GuavaRetryExecutor();
        Retryer retryer = retryExecutor.build(this.getRetryExecutorParameter());
        try {
            retryExecutor.call(retryer, () -> {
                EasyRetryLog.LOCAL.info("Batch asynchronous reporting ... <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)});
                CLIENT.reportRetryInfo(list);
                return null;
            }, throwable -> {
                EasyRetryLog.LOCAL.error("Data report failed. <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)});
                this.sendMessage((Throwable)throwable);
            }, o -> EasyRetryLog.LOCAL.info("Data report successful retry\uff1a<|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)}));
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("Data report failed. <|>{}<|>", new Object[]{JsonUtil.toJsonString(list), e});
        }
    }

    public RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter() {
        return new RetryExecutorParameter<WaitStrategy, StopStrategy>(){

            @Override
            public WaitStrategy backOff() {
                return WaitStrategies.fixedWait((long)2L, (TimeUnit)TimeUnit.SECONDS);
            }

            @Override
            public StopStrategy stop() {
                return StopStrategies.stopAfterAttempt((int)10);
            }

            @Override
            public List<RetryListener> getRetryListeners() {
                return Collections.singletonList(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        if (attempt.hasException()) {
                            EasyRetryLog.LOCAL.error("EasyRetry\u4e0a\u62a5\u5f02\u5e38\u6570\u636e\u65f6\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u7b2c[{}]\u6b21\u5c1d\u8bd5\u4e0a\u62a5 ", new Object[]{attempt.getAttemptNumber(), attempt.getExceptionCause()});
                        }
                    }
                });
            }
        };
    }

    private void sendMessage(Throwable e) {
        try {
            ConfigDTO.Notify notifyAttribute = GroupVersionCache.getNotifyAttribute((Integer)NotifySceneEnum.CLIENT_REPORT_ERROR.getNotifyScene());
            if (Objects.isNull(notifyAttribute)) {
                return;
            }
            EasyRetryProperties properties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
            AlarmContext context = AlarmContext.build().text(reportErrorTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), properties.getNamespace(), EasyRetryProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("\u4e0a\u62a5\u5f02\u5e38:[{}]", new Object[]{EasyRetryProperties.getGroup()}).notifyAttribute(notifyAttribute.getNotifyAttribute());
            EasyRetryAlarmFactory easyRetryAlarmFactory = (EasyRetryAlarmFactory)SpringContext.getBeanByType(EasyRetryAlarmFactory.class);
            Alarm alarmType = easyRetryAlarmFactory.getAlarmType(notifyAttribute.getNotifyType());
            alarmType.asyncSendMessage((Object)context);
        }
        catch (Exception e1) {
            EasyRetryLog.LOCAL.error("\u5ba2\u6237\u7aef\u53d1\u9001\u7ec4\u4ef6\u5f02\u5e38\u544a\u8b66\u5931\u8d25", new Object[]{e1});
        }
    }
}

