/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.client;

import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.client.common.annotation.Authentication;
import com.aizuda.easy.retry.client.common.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.common.log.report.LogMeta;
import com.aizuda.easy.retry.client.common.log.support.EasyRetryLogManager;
import com.aizuda.easy.retry.client.core.IdempotentIdGenerate;
import com.aizuda.easy.retry.client.core.RetryArgSerializer;
import com.aizuda.easy.retry.client.core.cache.RetryerInfoCache;
import com.aizuda.easy.retry.client.core.callback.RetryCompleteCallback;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.loader.EasyRetrySpiLoader;
import com.aizuda.easy.retry.client.core.log.RetryLogMeta;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.retryer.RetryerResultContext;
import com.aizuda.easy.retry.client.core.serializer.JacksonSerializer;
import com.aizuda.easy.retry.client.core.strategy.RetryStrategy;
import com.aizuda.easy.retry.client.model.DispatchRetryDTO;
import com.aizuda.easy.retry.client.model.DispatchRetryResultDTO;
import com.aizuda.easy.retry.client.model.GenerateRetryIdempotentIdDTO;
import com.aizuda.easy.retry.client.model.RetryCallbackDTO;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.RetryResultStatusEnum;
import com.aizuda.easy.retry.common.core.enums.RetryStatusEnum;
import com.aizuda.easy.retry.common.core.model.IdempotentIdContext;
import com.aizuda.easy.retry.common.core.model.Result;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.common.log.enums.LogTypeEnum;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry"})
public class RetryEndPoint {
    private static final Logger log = LoggerFactory.getLogger(RetryEndPoint.class);
    @Autowired
    @Qualifier(value="remoteRetryStrategies")
    private RetryStrategy retryStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/dispatch/v1"})
    @Authentication
    public Result<DispatchRetryResultDTO> dispatch(@RequestBody @Validated DispatchRetryDTO executeReqDto) {
        RetryerInfo retryerInfo = RetryerInfoCache.get(executeReqDto.getScene(), executeReqDto.getExecutorName());
        if (Objects.isNull(retryerInfo)) {
            EasyRetryLog.REMOTE.error("\u573a\u666f:[{}]\u914d\u7f6e\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u60a8\u7684\u573a\u666f\u548c\u6267\u884c\u5668\u662f\u5426\u5b58\u5728", new Object[]{executeReqDto.getScene()});
            throw new EasyRetryClientException("\u573a\u666f:[{}]\u914d\u7f6e\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u60a8\u7684\u573a\u666f\u548c\u6267\u884c\u5668\u662f\u5426\u5b58\u5728", (Object)executeReqDto.getScene());
        }
        RetryArgSerializer retryArgSerializer = EasyRetrySpiLoader.loadRetryArgSerializer();
        Object[] deSerialize = null;
        try {
            deSerialize = (Object[])retryArgSerializer.deSerialize(executeReqDto.getArgsStr(), retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
        }
        catch (JsonProcessingException e) {
            EasyRetryLog.REMOTE.error("\u53c2\u6570\u89e3\u6790\u5f02\u5e38", new Object[]{e});
            throw new EasyRetryClientException("\u53c2\u6570\u89e3\u6790\u5f02\u5e38", e);
        }
        DispatchRetryResultDTO executeRespDto = new DispatchRetryResultDTO();
        try {
            RetrySiteSnapshot.setAttemptNumber(executeReqDto.getRetryCount());
            RetryLogMeta retryLogMeta = new RetryLogMeta();
            retryLogMeta.setGroupName(executeReqDto.getGroupName());
            retryLogMeta.setNamespaceId(executeReqDto.getNamespaceId());
            retryLogMeta.setUniqueId(executeReqDto.getUniqueId());
            EasyRetryLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
            RetryerResultContext retryerResultContext = this.retryStrategy.openRetry(executeReqDto.getScene(), executeReqDto.getExecutorName(), deSerialize);
            if (RetrySiteSnapshot.isRetryForStatusCode()) {
                executeRespDto.setStatusCode(RetryResultStatusEnum.STOP.getStatus());
                executeRespDto.setExceptionMsg("\u4e0b\u6e38\u6807\u8bb0\u4e0d\u9700\u8981\u91cd\u8bd5");
            } else {
                RetryResultStatusEnum retryResultStatusEnum = retryerResultContext.getRetryResultStatusEnum();
                if (Objects.isNull(retryResultStatusEnum)) {
                    retryResultStatusEnum = RetryResultStatusEnum.STOP;
                    retryerResultContext.setMessage("\u672a\u83b7\u53d6\u91cd\u8bd5\u72b6\u6001. \u4efb\u52a1\u505c\u6b62");
                }
                executeRespDto.setStatusCode(retryResultStatusEnum.getStatus());
                executeRespDto.setExceptionMsg(retryerResultContext.getMessage());
            }
            executeRespDto.setIdempotentId(executeReqDto.getIdempotentId());
            executeRespDto.setUniqueId(executeReqDto.getUniqueId());
            if (Objects.nonNull(retryerResultContext.getResult())) {
                executeRespDto.setResultJson(JsonUtil.toJsonString((Object)retryerResultContext.getResult()));
            }
            if (Objects.equals(RetryResultStatusEnum.SUCCESS.getStatus(), executeRespDto.getStatusCode())) {
                EasyRetryLog.REMOTE.info("remote retry\u3010SUCCESS\u3011. count:[{}] result:[{}]", new Object[]{executeReqDto.getRetryCount(), executeRespDto.getResultJson()});
            } else if (Objects.equals(RetryResultStatusEnum.STOP.getStatus(), executeRespDto.getStatusCode())) {
                EasyRetryLog.REMOTE.warn("remote retry \u3010STOP\u3011. count:[{}] exceptionMsg:[{}]", new Object[]{executeReqDto.getRetryCount(), executeRespDto.getExceptionMsg()});
            } else if (Objects.equals(RetryResultStatusEnum.FAILURE.getStatus(), executeRespDto.getStatusCode())) {
                EasyRetryLog.REMOTE.error("remote retry \u3010FAILURE\u3011. count:[{}] ", new Object[]{executeReqDto.getRetryCount(), retryerResultContext.getThrowable()});
            } else {
                EasyRetryLog.REMOTE.error("remote retry \u3010UNKNOWN\u3011. count:[{}] result:[{}]", new Object[]{executeReqDto.getRetryCount(), executeRespDto.getResultJson(), retryerResultContext.getThrowable()});
            }
        }
        finally {
            RetrySiteSnapshot.removeAll();
            EasyRetryLogManager.removeAll();
        }
        return new Result((Object)executeRespDto);
    }

    @PostMapping(value={"/sync/version/v1"})
    @Authentication
    public Result syncVersion(@RequestBody ConfigDTO configDTO) {
        GroupVersionCache.configDTO = configDTO;
        return new Result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/callback/v1"})
    @Authentication
    public Result callback(@RequestBody @Validated RetryCallbackDTO callbackDTO) {
        RetryerInfo retryerInfo = null;
        Object[] deSerialize = null;
        try {
            RetryLogMeta retryLogMeta = new RetryLogMeta();
            retryLogMeta.setGroupName(callbackDTO.getGroup());
            retryLogMeta.setNamespaceId(callbackDTO.getNamespaceId());
            retryLogMeta.setUniqueId(callbackDTO.getUniqueId());
            EasyRetryLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
            retryerInfo = RetryerInfoCache.get(callbackDTO.getScene(), callbackDTO.getExecutorName());
            if (Objects.isNull(retryerInfo)) {
                EasyRetryLog.REMOTE.error("\u573a\u666f:[{}]\u914d\u7f6e\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u60a8\u7684\u573a\u666f\u548c\u6267\u884c\u5668\u662f\u5426\u5b58\u5728", new Object[]{callbackDTO.getScene()});
                Result result = new Result(0, "\u56de\u8c03\u5931\u8d25");
                return result;
            }
            RetryArgSerializer retryArgSerializer = EasyRetrySpiLoader.loadRetryArgSerializer();
            deSerialize = (Object[])retryArgSerializer.deSerialize(callbackDTO.getArgsStr(), retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
            Result result = this.doCallbackForSpringBean(callbackDTO, retryerInfo, deSerialize);
            return result;
        }
        catch (JsonProcessingException e) {
            EasyRetryLog.REMOTE.error("\u53c2\u6570\u89e3\u6790\u5f02\u5e38", new Object[]{e});
            Result result = new Result(0, "\u56de\u8c03\u5931\u8d25");
            return result;
        }
        catch (NoSuchBeanDefinitionException e) {
            Result result = this.doCallbackForOrdinaryClass(callbackDTO, retryerInfo, deSerialize);
            return result;
        }
        finally {
            EasyRetryLogManager.removeAll();
        }
    }

    private Result doCallbackForOrdinaryClass(RetryCallbackDTO callbackDTO, RetryerInfo retryerInfo, Object[] deSerialize) {
        Class<? extends RetryCompleteCallback> retryCompleteCallbackClazz = retryerInfo.getRetryCompleteCallback();
        try {
            RetryCompleteCallback retryCompleteCallback = retryCompleteCallbackClazz.newInstance();
            Method method = switch (Objects.requireNonNull(RetryStatusEnum.getByStatus((Integer)callbackDTO.getRetryStatus()))) {
                case RetryStatusEnum.FINISH -> retryCompleteCallbackClazz.getMethod("doSuccessCallback", String.class, String.class, Object[].class);
                case RetryStatusEnum.MAX_COUNT -> retryCompleteCallbackClazz.getMethod("doMaxRetryCallback", String.class, String.class, Object[].class);
                default -> throw new EasyRetryClientException("\u56de\u8c03\u72b6\u6001\u5f02\u5e38");
            };
            Assert.notNull((Object)method, () -> new EasyRetryClientException("no such method"));
            ReflectionUtils.invokeMethod((Method)method, (Object)retryCompleteCallback, (Object[])new Object[]{retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize});
            return new Result(1, "\u56de\u8c03\u6210\u529f");
        }
        catch (Exception ex) {
            return new Result(0, ex.getMessage());
        }
    }

    private Result doCallbackForSpringBean(RetryCallbackDTO callbackDTO, RetryerInfo retryerInfo, Object[] deSerialize) {
        Class<? extends RetryCompleteCallback> retryCompleteCallbackClazz = retryerInfo.getRetryCompleteCallback();
        RetryCompleteCallback retryCompleteCallback = (RetryCompleteCallback)SpringContext.getBeanByType(retryCompleteCallbackClazz);
        switch (Objects.requireNonNull(RetryStatusEnum.getByStatus((Integer)callbackDTO.getRetryStatus()))) {
            case FINISH: {
                retryCompleteCallback.doSuccessCallback(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize);
                break;
            }
            case MAX_COUNT: {
                retryCompleteCallback.doMaxRetryCallback(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), deSerialize);
                break;
            }
            default: {
                throw new EasyRetryClientException("\u56de\u8c03\u72b6\u6001\u5f02\u5e38");
            }
        }
        return new Result(1, "\u56de\u8c03\u6210\u529f");
    }

    @PostMapping(value={"/generate/idempotent-id/v1"})
    @Authentication
    public Result<String> idempotentIdGenerate(@RequestBody @Validated GenerateRetryIdempotentIdDTO generateRetryIdempotentIdDTO) {
        String idempotentId;
        String scene = generateRetryIdempotentIdDTO.getScene();
        String executorName = generateRetryIdempotentIdDTO.getExecutorName();
        String argsStr = generateRetryIdempotentIdDTO.getArgsStr();
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, executorName);
        Assert.notNull((Object)retryerInfo, () -> new EasyRetryClientException("\u91cd\u8bd5\u4fe1\u606f\u4e0d\u5b58\u5728 scene:[{}] executorName:[{}]", scene, executorName));
        Method executorMethod = retryerInfo.getMethod();
        JacksonSerializer retryArgSerializer = new JacksonSerializer();
        Object[] deSerialize = null;
        try {
            deSerialize = (Object[])retryArgSerializer.deSerialize(argsStr, retryerInfo.getExecutor().getClass(), retryerInfo.getMethod());
        }
        catch (JsonProcessingException e) {
            throw new EasyRetryClientException("\u53c2\u6570\u89e3\u6790\u5f02\u5e38", e);
        }
        try {
            Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryerInfo.getIdempotentIdGenerate();
            IdempotentIdGenerate generate = idempotentIdGenerate.newInstance();
            Method method = idempotentIdGenerate.getMethod("idGenerate", IdempotentIdContext.class);
            IdempotentIdContext idempotentIdContext = new IdempotentIdContext(scene, executorName, deSerialize, executorMethod.getName());
            idempotentId = (String)ReflectionUtils.invokeMethod((Method)method, (Object)generate, (Object[])new Object[]{idempotentIdContext});
        }
        catch (Exception exception) {
            EasyRetryLog.LOCAL.error("\u5e42\u7b49id\u751f\u6210\u5f02\u5e38\uff1a{},{}", new Object[]{scene, argsStr, exception});
            throw new EasyRetryClientException("idempotentId\u751f\u6210\u5f02\u5e38\uff1a{},{}", scene, argsStr);
        }
        return new Result((Object)idempotentId);
    }
}

