/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.retryer;

import com.aizuda.easy.retry.client.core.retryer.EasyRetryTemplate;
import com.aizuda.easy.retry.client.core.strategy.ExecutorMethod;
import com.aizuda.easy.retry.client.core.strategy.ManualRetryStrategies;
import com.aizuda.easy.retry.client.core.strategy.RetryStrategy;
import com.aizuda.easy.retry.common.core.context.SpringContext;

public class RetryTaskTemplateBuilder {
    private Class<? extends ExecutorMethod> executorMethodClass;
    private String scene;
    private Object[] params;

    public static RetryTaskTemplateBuilder newBuilder() {
        return new RetryTaskTemplateBuilder();
    }

    public RetryTaskTemplateBuilder withScene(String scene) {
        this.scene = scene;
        return this;
    }

    public RetryTaskTemplateBuilder withExecutorMethod(Class<? extends ExecutorMethod> executorMethod) {
        this.executorMethodClass = executorMethod;
        return this;
    }

    public RetryTaskTemplateBuilder withParam(Object params) {
        this.params = new Object[]{params};
        return this;
    }

    public EasyRetryTemplate build() {
        EasyRetryTemplate easyRetryTemplate = new EasyRetryTemplate();
        easyRetryTemplate.setParams(this.params);
        easyRetryTemplate.setExecutorMethodClass(this.executorMethodClass);
        easyRetryTemplate.setScene(this.scene);
        RetryStrategy retryStrategy = (RetryStrategy)SpringContext.getBeanByType(ManualRetryStrategies.class);
        easyRetryTemplate.setRetryStrategy(retryStrategy);
        return easyRetryTemplate;
    }
}

