/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import com.aizuda.easy.retry.client.common.cache.GroupVersionCache;
import com.aizuda.easy.retry.client.common.client.NettyClient;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.common.proxy.RequestBuilder;
import com.aizuda.easy.retry.client.core.report.AbstractReport;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.common.core.alarm.Alarm;
import com.aizuda.easy.retry.common.core.alarm.AlarmContext;
import com.aizuda.easy.retry.common.core.alarm.EasyRetryAlarmFactory;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.NotifySceneEnum;
import com.aizuda.easy.retry.common.core.model.NettyResult;
import com.aizuda.easy.retry.common.core.util.EnvironmentUtils;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.model.dto.ConfigDTO;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncReport
extends AbstractReport {
    private static final Logger log = LoggerFactory.getLogger(SyncReport.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static String reportErrorTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u540c\u6b65\u4e0a\u62a5\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    @Autowired
    private EasyRetryProperties easyRetryProperties;

    public boolean supports(boolean async) {
        return !async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskDTO retryTaskDTO = this.buildRetryTaskDTO(scene, targetClassName, args);
        NettyClient client = (NettyClient)RequestBuilder.newBuilder().client(NettyClient.class).async(Boolean.FALSE.booleanValue()).timeout(timeout).unit(unit).build();
        try {
            NettyResult result = client.reportRetryInfo(Collections.singletonList(retryTaskDTO));
            EasyRetryLog.LOCAL.debug("Data report result result:[{}]", new Object[]{JsonUtil.toJsonString((Object)result)});
            return (Boolean)result.getData();
        }
        catch (Exception e) {
            this.sendMessage(e);
            throw e;
        }
    }

    private void sendMessage(Throwable e) {
        try {
            ConfigDTO.Notify notifyAttribute = GroupVersionCache.getNotifyAttribute((Integer)NotifySceneEnum.CLIENT_REPORT_ERROR.getNotifyScene());
            if (Objects.isNull(notifyAttribute)) {
                return;
            }
            AlarmContext context = AlarmContext.build().text(reportErrorTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), this.easyRetryProperties.getNamespace(), EasyRetryProperties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("\u540c\u6b65\u4e0a\u62a5\u5f02\u5e38:[{}]", new Object[]{EasyRetryProperties.getGroup()}).notifyAttribute(notifyAttribute.getNotifyAttribute());
            EasyRetryAlarmFactory easyRetryAlarmFactory = (EasyRetryAlarmFactory)SpringContext.getBeanByType(EasyRetryAlarmFactory.class);
            Alarm alarmType = easyRetryAlarmFactory.getAlarmType(notifyAttribute.getNotifyType());
            alarmType.asyncSendMessage((Object)context);
        }
        catch (Exception e1) {
            EasyRetryLog.LOCAL.error("\u5ba2\u6237\u7aef\u53d1\u9001\u7ec4\u4ef6\u5f02\u5e38\u544a\u8b66\u5931\u8d25", new Object[]{e1});
        }
    }
}

