/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.common.window.SlidingWindow;
import com.aizuda.easy.retry.client.core.report.AbstractReport;
import com.aizuda.easy.retry.client.core.report.ReportListener;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.common.core.window.Listener;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncReport
extends AbstractReport
implements Lifecycle {
    @Autowired
    private EasyRetryProperties easyRetryProperties;
    private SlidingWindow<RetryTaskDTO> slidingWindow;

    public boolean supports(boolean async) {
        return async;
    }

    @Override
    public boolean doReport(RetryerInfo retryerInfo, Object[] params) {
        return this.syncReport(retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params, retryerInfo.getTimeout(), retryerInfo.getUnit());
    }

    public Boolean syncReport(String scene, String targetClassName, Object[] args, long timeout, TimeUnit unit) {
        RetryTaskDTO retryTaskDTO = this.buildRetryTaskDTO(scene, targetClassName, args);
        this.slidingWindow.add((Object)retryTaskDTO);
        return Boolean.TRUE;
    }

    public void start() {
        EasyRetryProperties.SlidingWindowConfig slidingWindowConfig = this.easyRetryProperties.getSlidingWindow();
        this.slidingWindow = SlidingWindow.Builder.newBuilder().withTotalThreshold(slidingWindowConfig.getTotalThreshold()).withWindowTotalThreshold(slidingWindowConfig.getWindowTotalThreshold()).withDuration(slidingWindowConfig.getDuration(), slidingWindowConfig.getChronoUnit()).withListener((Listener)new ReportListener()).build();
        this.slidingWindow.start();
    }

    public void close() {
        EasyRetryLog.LOCAL.info("AsyncReport about to shutdown", new Object[0]);
        if (Objects.nonNull(this.slidingWindow)) {
            this.slidingWindow.end();
        }
        EasyRetryLog.LOCAL.info("AsyncReport has been shutdown", new Object[0]);
    }
}

