/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.report;

import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.client.common.Report;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.core.IdempotentIdGenerate;
import com.aizuda.easy.retry.client.core.RetryArgSerializer;
import com.aizuda.easy.retry.client.core.cache.RetryerInfoCache;
import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.client.core.loader.EasyRetrySpiLoader;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.common.core.expression.ExpressionEngine;
import com.aizuda.easy.retry.common.core.model.IdempotentIdContext;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractReport
implements Report {
    private static final Logger log = LoggerFactory.getLogger(AbstractReport.class);

    public boolean report(String scene, String targetClassName, Object[] params) {
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, targetClassName);
        Assert.notNull((Object)retryerInfo, () -> new EasyRetryClientException("retryerInfo is null"));
        if (RetrySiteSnapshot.getStage().equals(RetrySiteSnapshot.EnumStage.REMOTE.getStage()) && !retryerInfo.isForceReport()) {
            EasyRetryLog.LOCAL.info("Successfully reported, no need to repeat reporting. scene:[{}] targetClassName:[{}] args:[{}]", new Object[]{retryerInfo.getScene(), retryerInfo.getExecutorClassName(), params});
            return Boolean.TRUE;
        }
        return this.doReport(retryerInfo, params);
    }

    public abstract boolean doReport(RetryerInfo var1, Object[] var2);

    protected RetryTaskDTO buildRetryTaskDTO(String scene, String targetClassName, Object[] args) {
        String idempotentId;
        RetryerInfo retryerInfo = RetryerInfoCache.get(scene, targetClassName);
        Method executorMethod = retryerInfo.getMethod();
        RetryTaskDTO retryTaskDTO = new RetryTaskDTO();
        try {
            Class<? extends IdempotentIdGenerate> idempotentIdGenerate = retryerInfo.getIdempotentIdGenerate();
            IdempotentIdGenerate generate = idempotentIdGenerate.newInstance();
            Method method = idempotentIdGenerate.getMethod("idGenerate", IdempotentIdContext.class);
            IdempotentIdContext idempotentIdContext = new IdempotentIdContext(scene, targetClassName, args, executorMethod.getName());
            idempotentId = (String)ReflectionUtils.invokeMethod((Method)method, (Object)generate, (Object[])new Object[]{idempotentIdContext});
        }
        catch (Exception exception) {
            EasyRetryLog.LOCAL.error("\u5e42\u7b49id\u751f\u6210\u5f02\u5e38\uff1a{},{}", new Object[]{scene, args, exception});
            throw new EasyRetryClientException("idempotentId\u751f\u6210\u5f02\u5e38\uff1a{},{}", scene, args);
        }
        RetryArgSerializer retryArgSerializer = EasyRetrySpiLoader.loadRetryArgSerializer();
        String serialize = retryArgSerializer.serialize(args);
        retryTaskDTO.setIdempotentId(idempotentId);
        retryTaskDTO.setExecutorName(targetClassName);
        retryTaskDTO.setArgsStr(serialize);
        retryTaskDTO.setGroupName(EasyRetryProperties.getGroup());
        retryTaskDTO.setSceneName(scene);
        String expression = retryerInfo.getBizNo();
        ExpressionEngine expressionEngine = EasyRetrySpiLoader.loadExpressionEngine();
        retryTaskDTO.setBizNo((String)expressionEngine.eval(expression, new Object[]{args, executorMethod}));
        return retryTaskDTO;
    }
}

