/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.plugin;

import com.aizuda.easy.retry.client.core.exception.EasyRetryClientException;
import com.aizuda.easy.retry.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.easy.retry.common.core.model.EasyRetryHeaders;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderPlugins {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderPlugins.class);

    private RequestHeaderPlugins() {
    }

    public static Map<String, String> requestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        EasyRetryHeaders retryHeader = RetrySiteSnapshot.getRetryHeader();
        if (Objects.nonNull(retryHeader)) {
            long callRemoteTime = System.currentTimeMillis();
            Long entryMethodTime = RetrySiteSnapshot.getEntryMethodTime();
            if (Objects.isNull(entryMethodTime)) {
                EasyRetryLog.LOCAL.warn("entry method time is null. easyRetryId:[{}]", new Object[]{retryHeader.getEasyRetryId()});
            } else {
                long transmitTime = retryHeader.getDdl() - (callRemoteTime - entryMethodTime);
                EasyRetryLog.LOCAL.info("RPC\u4f20\u9012header\u5934 callRemoteTime:[{}] - entryMethodTime:[{}] = transmitTime:[{}]", new Object[]{callRemoteTime, entryMethodTime, transmitTime});
                if (transmitTime > 0L) {
                    retryHeader.setDdl(transmitTime);
                    RetrySiteSnapshot.setEntryMethodTime(System.currentTimeMillis());
                } else {
                    throw new EasyRetryClientException("\u8c03\u7528\u94fe\u8d85\u65f6, \u4e0d\u5728\u7ee7\u7eed\u8c03\u7528\u540e\u9762\u8bf7\u6c42");
                }
            }
            header.put("easy-retry", JsonUtil.toJsonString((Object)retryHeader));
        }
        return header;
    }
}

