/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.loader;

import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.easy.retry.client.core.RetryArgSerializer;
import com.aizuda.easy.retry.client.core.RetrySiteSnapshotContext;
import com.aizuda.easy.retry.client.core.event.EasyRetryListener;
import com.aizuda.easy.retry.client.core.event.SimpleEasyRetryListener;
import com.aizuda.easy.retry.client.core.expression.ExpressionInvocationHandler;
import com.aizuda.easy.retry.client.core.intercepter.ThreadLockRetrySiteSnapshotContext;
import com.aizuda.easy.retry.client.core.serializer.JacksonSerializer;
import com.aizuda.easy.retry.common.core.expression.ExpressionEngine;
import com.aizuda.easy.retry.common.core.expression.ExpressionFactory;
import com.aizuda.easy.retry.common.core.expression.strategy.SpELExpressionEngine;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class EasyRetrySpiLoader {
    private EasyRetrySpiLoader() {
    }

    public static RetryArgSerializer loadRetryArgSerializer() {
        return Optional.ofNullable((RetryArgSerializer)ServiceLoaderUtil.loadFirst(RetryArgSerializer.class)).orElse(new JacksonSerializer());
    }

    public static List<EasyRetryListener> loadEasyRetryListener() {
        List easyRetryListeners = ServiceLoaderUtil.loadList(EasyRetryListener.class);
        if (CollectionUtils.isEmpty((Collection)easyRetryListeners)) {
            return Collections.singletonList(new SimpleEasyRetryListener());
        }
        return easyRetryListeners;
    }

    public static <T> RetrySiteSnapshotContext<T> loadRetrySiteSnapshotContext() {
        return Optional.ofNullable((RetrySiteSnapshotContext)ServiceLoaderUtil.loadFirst(RetrySiteSnapshotContext.class)).orElse(new ThreadLockRetrySiteSnapshotContext(new ThreadLocal()));
    }

    public static ExpressionEngine loadExpressionEngine() {
        ExpressionEngine expressionEngine = Optional.ofNullable((ExpressionEngine)ServiceLoaderUtil.loadFirst(ExpressionEngine.class)).orElse((ExpressionEngine)new SpELExpressionEngine());
        return ExpressionFactory.getExpressionEngine((InvocationHandler)new ExpressionInvocationHandler(expressionEngine));
    }
}

