/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.intercepter;

import com.aizuda.easy.retry.client.core.annotation.Retryable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.aop.support.annotation.AnnotationMethodMatcher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class EasyRetryPointcutAdvisor
extends AbstractPointcutAdvisor
implements IntroductionAdvisor,
BeanFactoryAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EasyRetryPointcutAdvisor.class);
    private Advice advice;
    private Pointcut pointcut;
    private BeanFactory beanFactory;
    private MethodInterceptor easyRetryInterceptor;

    public EasyRetryPointcutAdvisor(MethodInterceptor methodInterceptor) {
        this.easyRetryInterceptor = methodInterceptor;
    }

    public void afterPropertiesSet() throws Exception {
        this.pointcut = this.buildPointcut();
        this.advice = this.buildAdvice();
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(this.beanFactory);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClassFilter getClassFilter() {
        return this.pointcut.getClassFilter();
    }

    public Class<?>[] getInterfaces() {
        return new Class[]{Retryable.class};
    }

    public void validateInterfaces() throws IllegalArgumentException {
    }

    public Advice getAdvice() {
        return this.advice;
    }

    protected Advice buildAdvice() {
        return this.easyRetryInterceptor;
    }

    protected Pointcut buildPointcut() {
        return new EasyRetryAnnotationMethodPointcut(Retryable.class);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    private static final class EasyRetryAnnotationMethodPointcut
    extends StaticMethodMatcherPointcut {
        private final MethodMatcher methodResolver;

        EasyRetryAnnotationMethodPointcut(Class<? extends Annotation> annotationType) {
            this.methodResolver = new AnnotationMethodMatcher(annotationType, true);
            this.setClassFilter((ClassFilter)new EasyRetryAnnotationClassOrMethodFilter(annotationType));
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return this.methodResolver.matches(method, targetClass);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EasyRetryAnnotationMethodPointcut)) {
                return false;
            }
            EasyRetryAnnotationMethodPointcut otherAdvisor = (EasyRetryAnnotationMethodPointcut)((Object)other);
            return ObjectUtils.nullSafeEquals((Object)this.methodResolver, (Object)otherAdvisor.methodResolver);
        }
    }

    private static class AnnotationMethodsResolver {
        private final Class<? extends Annotation> annotationType;

        public AnnotationMethodsResolver(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean hasAnnotatedMethods(Class<?> clazz) {
            AtomicBoolean found = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(clazz, method -> {
                if (found.get()) {
                    return;
                }
                Annotation annotation = AnnotationUtils.findAnnotation((Method)method, this.annotationType);
                if (annotation != null) {
                    found.set(true);
                }
            });
            return found.get();
        }
    }

    private static final class EasyRetryAnnotationClassOrMethodFilter
    extends AnnotationClassFilter {
        private final AnnotationMethodsResolver methodResolver;

        EasyRetryAnnotationClassOrMethodFilter(Class<? extends Annotation> annotationType) {
            super(annotationType, true);
            this.methodResolver = new AnnotationMethodsResolver(annotationType);
        }

        public boolean matches(Class<?> clazz) {
            return super.matches(clazz) || this.methodResolver.hasAnnotatedMethods(clazz);
        }
    }
}

