/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.core.executor;

import com.aizuda.easy.retry.client.core.RetryExecutor;
import com.aizuda.easy.retry.client.core.retryer.RetryerInfo;
import com.aizuda.easy.retry.client.core.strategy.ExecutorAnnotationMethod;
import com.aizuda.easy.retry.client.core.strategy.ExecutorMethod;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryExecutor<BR, SR>
implements RetryExecutor<BR, SR> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryExecutor.class);
    protected RetryerInfo retryerInfo;

    @Override
    public Object execute(Object ... params) {
        return this.doExecute(params);
    }

    public Object doExecute(Object ... params) {
        Class<? extends ExecutorMethod> retryMethodClass = this.retryerInfo.getExecutorMethod();
        if (retryMethodClass.isAssignableFrom(ExecutorAnnotationMethod.class)) {
            EasyRetryLog.LOCAL.info("\u6267\u884c\u6ce8\u89e3\u91cd\u8bd5\u65b9\u6cd5\uff1a{},\u53c2\u6570\u4e3a\uff1a{}", new Object[]{retryMethodClass.getName(), JsonUtil.toJsonString((Object)params)});
            ExecutorAnnotationMethod retryAnnotationMethod = new ExecutorAnnotationMethod(this.retryerInfo);
            return retryAnnotationMethod.doExecute(params);
        }
        EasyRetryLog.LOCAL.info("\u6267\u884c\u81ea\u5b9a\u4e49\u91cd\u8bd5\u65b9\u6cd5\uff1a{},\u53c2\u6570\u4e3a\uff1a{}", new Object[]{retryMethodClass.getName(), JsonUtil.toJsonString((Object)params)});
        ExecutorMethod executorMethod = (ExecutorMethod)SpringContext.getBeanByType(retryMethodClass);
        return executorMethod.doExecute(params);
    }

    @Override
    public RetryerInfo getRetryerInfo() {
        return this.retryerInfo;
    }
}

