/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.netty;

import com.aizuda.easy.retry.common.core.model.NettyResult;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcContext {
    private static final Logger log = LoggerFactory.getLogger(RpcContext.class);
    private static final ConcurrentMap<Long, CompletableFuture> COMPLETABLE_FUTURE = new ConcurrentHashMap<Long, CompletableFuture>();
    private static final ConcurrentMap<Long, Consumer> CALLBACK_CONSUMER = new ConcurrentHashMap<Long, Consumer>();

    public static void invoke(Long requestId, NettyResult nettyResult) {
        try {
            Optional.ofNullable(RpcContext.getCompletableFuture(requestId)).ifPresent(completableFuture -> completableFuture.complete(nettyResult));
            Optional.ofNullable(RpcContext.getConsumer(requestId)).ifPresent(consumer -> consumer.accept(nettyResult));
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("\u56de\u8c03\u5904\u7406\u5931\u8d25 requestId:[{}]", new Object[]{requestId, e});
        }
        finally {
            COMPLETABLE_FUTURE.remove(requestId);
            CALLBACK_CONSUMER.remove(requestId);
        }
    }

    public static <R> void setCompletableFuture(long id, CompletableFuture<R> completableFuture, Consumer<R> callable) {
        if (Objects.nonNull(completableFuture)) {
            COMPLETABLE_FUTURE.put(id, completableFuture);
        }
        if (Objects.nonNull(callable)) {
            CALLBACK_CONSUMER.put(id, callable);
        }
    }

    public static <R> void setCompletableFuture(Long id, Consumer<R> callable) {
        RpcContext.setCompletableFuture(id, null, callable);
    }

    public static <R> void setCompletableFuture(Long id, CompletableFuture<R> completableFuture) {
        RpcContext.setCompletableFuture(id, completableFuture, null);
    }

    public static CompletableFuture<Object> getCompletableFuture(Long id) {
        return (CompletableFuture)COMPLETABLE_FUTURE.get(id);
    }

    public static Consumer getConsumer(Long id) {
        return (Consumer)CALLBACK_CONSUMER.get(id);
    }
}

