/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.config;

import com.aizuda.easy.retry.common.core.context.SpringContext;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="easy-retry")
public class EasyRetryProperties {
    private String namespace;
    private String group;
    private String token;
    private String host;
    private Integer port;
    private SlidingWindowConfig slidingWindow = new SlidingWindowConfig();
    private LogSlidingWindowConfig logSlidingWindow = new LogSlidingWindowConfig();
    private ServerConfig server = new ServerConfig();

    public static String getGroup() {
        EasyRetryProperties properties = (EasyRetryProperties)SpringContext.getBean(EasyRetryProperties.class);
        return Objects.requireNonNull(properties).group;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getToken() {
        return this.token;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public SlidingWindowConfig getSlidingWindow() {
        return this.slidingWindow;
    }

    public LogSlidingWindowConfig getLogSlidingWindow() {
        return this.logSlidingWindow;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setSlidingWindow(SlidingWindowConfig slidingWindow) {
        this.slidingWindow = slidingWindow;
    }

    public void setLogSlidingWindow(LogSlidingWindowConfig logSlidingWindow) {
        this.logSlidingWindow = logSlidingWindow;
    }

    public void setServer(ServerConfig server) {
        this.server = server;
    }

    public static class SlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 10L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlidingWindowConfig)) {
                return false;
            }
            SlidingWindowConfig other = (SlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "EasyRetryProperties.SlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }

    public static class LogSlidingWindowConfig {
        private int totalThreshold = 50;
        private int windowTotalThreshold = 150;
        private long duration = 5L;
        private ChronoUnit chronoUnit = ChronoUnit.SECONDS;

        public int getTotalThreshold() {
            return this.totalThreshold;
        }

        public int getWindowTotalThreshold() {
            return this.windowTotalThreshold;
        }

        public long getDuration() {
            return this.duration;
        }

        public ChronoUnit getChronoUnit() {
            return this.chronoUnit;
        }

        public void setTotalThreshold(int totalThreshold) {
            this.totalThreshold = totalThreshold;
        }

        public void setWindowTotalThreshold(int windowTotalThreshold) {
            this.windowTotalThreshold = windowTotalThreshold;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setChronoUnit(ChronoUnit chronoUnit) {
            this.chronoUnit = chronoUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogSlidingWindowConfig)) {
                return false;
            }
            LogSlidingWindowConfig other = (LogSlidingWindowConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotalThreshold() != other.getTotalThreshold()) {
                return false;
            }
            if (this.getWindowTotalThreshold() != other.getWindowTotalThreshold()) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            ChronoUnit this$chronoUnit = this.getChronoUnit();
            ChronoUnit other$chronoUnit = other.getChronoUnit();
            return !(this$chronoUnit == null ? other$chronoUnit != null : !this$chronoUnit.equals(other$chronoUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LogSlidingWindowConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTotalThreshold();
            result = result * 59 + this.getWindowTotalThreshold();
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            ChronoUnit $chronoUnit = this.getChronoUnit();
            result = result * 59 + ($chronoUnit == null ? 43 : $chronoUnit.hashCode());
            return result;
        }

        public String toString() {
            return "EasyRetryProperties.LogSlidingWindowConfig(totalThreshold=" + this.getTotalThreshold() + ", windowTotalThreshold=" + this.getWindowTotalThreshold() + ", duration=" + this.getDuration() + ", chronoUnit=" + this.getChronoUnit() + ")";
        }
    }

    public static class ServerConfig {
        private String host = "127.0.0.1";
        private int port = 1788;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfig)) {
                return false;
            }
            ServerConfig other = (ServerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "EasyRetryProperties.ServerConfig(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }
}

