/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.client.common.report;

import com.aizuda.easy.retry.client.common.Lifecycle;
import com.aizuda.easy.retry.client.common.Report;
import com.aizuda.easy.retry.client.common.config.EasyRetryProperties;
import com.aizuda.easy.retry.client.common.report.ReportLogListener;
import com.aizuda.easy.retry.client.common.util.ThreadLocalLogUtil;
import com.aizuda.easy.retry.client.common.window.SlidingWindow;
import com.aizuda.easy.retry.common.core.model.JobContext;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.common.log.dto.LogContentDTO;
import com.aizuda.easy.retry.server.model.dto.LogTaskDTO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncReportLog
implements Lifecycle,
Report {
    private static final Logger log = LoggerFactory.getLogger(AsyncReportLog.class);
    @Autowired
    private EasyRetryProperties easyRetryProperties;
    private SlidingWindow<LogTaskDTO> slidingWindow;

    public Boolean syncReportLog(LogContentDTO logContent) {
        LogTaskDTO logTaskDTO = this.buildLogTaskDTO(logContent);
        this.slidingWindow.add(logTaskDTO);
        return Boolean.TRUE;
    }

    @Override
    public void start() {
        EasyRetryProperties.LogSlidingWindowConfig logSlidingWindow = this.easyRetryProperties.getLogSlidingWindow();
        this.slidingWindow = SlidingWindow.Builder.newBuilder().withTotalThreshold(logSlidingWindow.getTotalThreshold()).withWindowTotalThreshold(logSlidingWindow.getWindowTotalThreshold()).withDuration(logSlidingWindow.getDuration(), logSlidingWindow.getChronoUnit()).withListener(new ReportLogListener()).build();
        this.slidingWindow.start();
    }

    @Override
    public void close() {
        EasyRetryLog.LOCAL.info("AsyncReport Log about to shutdown", new Object[0]);
        if (Objects.nonNull(this.slidingWindow)) {
            this.slidingWindow.end();
        }
        EasyRetryLog.LOCAL.info("AsyncReport Log has been shutdown", new Object[0]);
    }

    protected LogTaskDTO buildLogTaskDTO(LogContentDTO logContentDTO) {
        JobContext context = ThreadLocalLogUtil.getContext();
        LogTaskDTO logTaskDTO = new LogTaskDTO();
        logTaskDTO.setJobId(context.getJobId());
        logTaskDTO.setTaskId(context.getTaskId());
        logTaskDTO.setTaskBatchId(context.getTaskBatchId());
        logTaskDTO.setRealTime(logContentDTO.getTimeStamp());
        logTaskDTO.setNamespaceId(context.getNamespaceId());
        logTaskDTO.setGroupName(context.getGroupName());
        logTaskDTO.setFieldList(logContentDTO.getFieldList());
        return logTaskDTO;
    }

    @Override
    public boolean supports(boolean async) {
        return false;
    }

    @Override
    public boolean report(String scene, String targetClassName, Object[] args) {
        return false;
    }
}

